package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComponentConfigurationRecommendationRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    tier: zio.aws.applicationinsights.model.Tier,
    recommendationType: Optional[
      zio.aws.applicationinsights.model.RecommendationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest = {
    import DescribeComponentConfigurationRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .tier(tier.unwrap)
      .optionallyWith(recommendationType.map(value => value.unwrap))(
        _.recommendationType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest
      .wrap(buildAwsValue())
}
object DescribeComponentConfigurationRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest =
      zio.aws.applicationinsights.model
        .DescribeComponentConfigurationRecommendationRequest(
          resourceGroupName,
          componentName,
          tier,
          recommendationType.map(value => value)
        )
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def tier: zio.aws.applicationinsights.model.Tier
    def recommendationType
        : Optional[zio.aws.applicationinsights.model.RecommendationType]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getTier: ZIO[Any, Nothing, zio.aws.applicationinsights.model.Tier] =
      ZIO.succeed(tier)
    def getRecommendationType: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.RecommendationType
    ] = AwsError.unwrapOptionField("recommendationType", recommendationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest
  ) extends zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val tier: zio.aws.applicationinsights.model.Tier =
      zio.aws.applicationinsights.model.Tier.wrap(impl.tier())
    override val recommendationType
        : Optional[zio.aws.applicationinsights.model.RecommendationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationType())
        .map(value =>
          zio.aws.applicationinsights.model.RecommendationType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest
  ): zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
