package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  OpsItemSNSTopicArn,
  AutoConfigEnabled,
  LifeCycle,
  AccountId,
  Remarks,
  ResourceGroupName,
  CWEMonitorEnabled,
  OpsCenterEnabled
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationInfo(
    accountId: Optional[AccountId] = Optional.Absent,
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    lifeCycle: Optional[LifeCycle] = Optional.Absent,
    opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn] = Optional.Absent,
    opsCenterEnabled: Optional[OpsCenterEnabled] = Optional.Absent,
    cweMonitorEnabled: Optional[CWEMonitorEnabled] = Optional.Absent,
    remarks: Optional[Remarks] = Optional.Absent,
    autoConfigEnabled: Optional[AutoConfigEnabled] = Optional.Absent,
    discoveryType: Optional[zio.aws.applicationinsights.model.DiscoveryType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo = {
    import ApplicationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        lifeCycle.map(value => LifeCycle.unwrap(value): java.lang.String)
      )(_.lifeCycle)
      .optionallyWith(
        opsItemSNSTopicArn.map(value =>
          OpsItemSNSTopicArn.unwrap(value): java.lang.String
        )
      )(_.opsItemSNSTopicArn)
      .optionallyWith(
        opsCenterEnabled.map(value =>
          OpsCenterEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.opsCenterEnabled)
      .optionallyWith(
        cweMonitorEnabled.map(value =>
          CWEMonitorEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.cweMonitorEnabled)
      .optionallyWith(
        remarks.map(value => Remarks.unwrap(value): java.lang.String)
      )(_.remarks)
      .optionallyWith(
        autoConfigEnabled.map(value =>
          AutoConfigEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.autoConfigEnabled)
      .optionallyWith(discoveryType.map(value => value.unwrap))(_.discoveryType)
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly =
    zio.aws.applicationinsights.model.ApplicationInfo.wrap(buildAwsValue())
}
object ApplicationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ApplicationInfo =
      zio.aws.applicationinsights.model.ApplicationInfo(
        accountId.map(value => value),
        resourceGroupName.map(value => value),
        lifeCycle.map(value => value),
        opsItemSNSTopicArn.map(value => value),
        opsCenterEnabled.map(value => value),
        cweMonitorEnabled.map(value => value),
        remarks.map(value => value),
        autoConfigEnabled.map(value => value),
        discoveryType.map(value => value)
      )
    def accountId: Optional[AccountId]
    def resourceGroupName: Optional[ResourceGroupName]
    def lifeCycle: Optional[LifeCycle]
    def opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn]
    def opsCenterEnabled: Optional[OpsCenterEnabled]
    def cweMonitorEnabled: Optional[CWEMonitorEnabled]
    def remarks: Optional[Remarks]
    def autoConfigEnabled: Optional[AutoConfigEnabled]
    def discoveryType: Optional[zio.aws.applicationinsights.model.DiscoveryType]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getLifeCycle: ZIO[Any, AwsError, LifeCycle] =
      AwsError.unwrapOptionField("lifeCycle", lifeCycle)
    def getOpsItemSNSTopicArn: ZIO[Any, AwsError, OpsItemSNSTopicArn] =
      AwsError.unwrapOptionField("opsItemSNSTopicArn", opsItemSNSTopicArn)
    def getOpsCenterEnabled: ZIO[Any, AwsError, OpsCenterEnabled] =
      AwsError.unwrapOptionField("opsCenterEnabled", opsCenterEnabled)
    def getCweMonitorEnabled: ZIO[Any, AwsError, CWEMonitorEnabled] =
      AwsError.unwrapOptionField("cweMonitorEnabled", cweMonitorEnabled)
    def getRemarks: ZIO[Any, AwsError, Remarks] =
      AwsError.unwrapOptionField("remarks", remarks)
    def getAutoConfigEnabled: ZIO[Any, AwsError, AutoConfigEnabled] =
      AwsError.unwrapOptionField("autoConfigEnabled", autoConfigEnabled)
    def getDiscoveryType
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.DiscoveryType] =
      AwsError.unwrapOptionField("discoveryType", discoveryType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
  ) extends zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val lifeCycle: Optional[LifeCycle] = zio.aws.core.internal
      .optionalFromNullable(impl.lifeCycle())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LifeCycle(value)
      )
    override val opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsItemSNSTopicArn())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.OpsItemSNSTopicArn(value)
        )
    override val opsCenterEnabled: Optional[OpsCenterEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsCenterEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.OpsCenterEnabled(value)
        )
    override val cweMonitorEnabled: Optional[CWEMonitorEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cweMonitorEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.CWEMonitorEnabled(value)
        )
    override val remarks: Optional[Remarks] = zio.aws.core.internal
      .optionalFromNullable(impl.remarks())
      .map(value => zio.aws.applicationinsights.model.primitives.Remarks(value))
    override val autoConfigEnabled: Optional[AutoConfigEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoConfigEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.AutoConfigEnabled(value)
        )
    override val discoveryType
        : Optional[zio.aws.applicationinsights.model.DiscoveryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.discoveryType())
        .map(value =>
          zio.aws.applicationinsights.model.DiscoveryType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
  ): zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly = new Wrapper(
    impl
  )
}
