package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  WorkloadId,
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveWorkloadRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    workloadId: WorkloadId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadRequest = {
    import RemoveWorkloadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .workloadId(WorkloadId.unwrap(workloadId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.RemoveWorkloadRequest.ReadOnly =
    zio.aws.applicationinsights.model.RemoveWorkloadRequest
      .wrap(buildAwsValue())
}
object RemoveWorkloadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.RemoveWorkloadRequest =
      zio.aws.applicationinsights.model
        .RemoveWorkloadRequest(resourceGroupName, componentName, workloadId)
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def workloadId: WorkloadId
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getWorkloadId: ZIO[Any, Nothing, WorkloadId] = ZIO.succeed(workloadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadRequest
  ) extends zio.aws.applicationinsights.model.RemoveWorkloadRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val workloadId: WorkloadId =
      zio.aws.applicationinsights.model.primitives.WorkloadId(impl.workloadId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadRequest
  ): zio.aws.applicationinsights.model.RemoveWorkloadRequest.ReadOnly =
    new Wrapper(impl)
}
