package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{AccountId, ObservationId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeObservationRequest(
    observationId: ObservationId,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest = {
    import DescribeObservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
      .builder()
      .observationId(ObservationId.unwrap(observationId): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeObservationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeObservationRequest
      .wrap(buildAwsValue())
}
object DescribeObservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeObservationRequest =
      zio.aws.applicationinsights.model.DescribeObservationRequest(
        observationId,
        accountId.map(value => value)
      )
    def observationId: ObservationId
    def accountId: Optional[AccountId]
    def getObservationId: ZIO[Any, Nothing, ObservationId] =
      ZIO.succeed(observationId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
  ) extends zio.aws.applicationinsights.model.DescribeObservationRequest.ReadOnly {
    override val observationId: ObservationId =
      zio.aws.applicationinsights.model.primitives
        .ObservationId(impl.observationId())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
  ): zio.aws.applicationinsights.model.DescribeObservationRequest.ReadOnly =
    new Wrapper(impl)
}
