package zio.aws.applicationinsights.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  ConfigurationEventMonitoredResourceARN,
  ConfigurationEventTime,
  AccountId,
  ConfigurationEventDetail,
  ConfigurationEventResourceName,
  ResourceGroupName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ConfigurationEvent(
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    monitoredResourceARN: Optional[ConfigurationEventMonitoredResourceARN] =
      Optional.Absent,
    eventStatus: Optional[
      zio.aws.applicationinsights.model.ConfigurationEventStatus
    ] = Optional.Absent,
    eventResourceType: Optional[
      zio.aws.applicationinsights.model.ConfigurationEventResourceType
    ] = Optional.Absent,
    eventTime: Optional[ConfigurationEventTime] = Optional.Absent,
    eventDetail: Optional[ConfigurationEventDetail] = Optional.Absent,
    eventResourceName: Optional[ConfigurationEventResourceName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEvent = {
    import ConfigurationEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ConfigurationEvent
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        monitoredResourceARN.map(value =>
          ConfigurationEventMonitoredResourceARN.unwrap(value): java.lang.String
        )
      )(_.monitoredResourceARN)
      .optionallyWith(eventStatus.map(value => value.unwrap))(_.eventStatus)
      .optionallyWith(eventResourceType.map(value => value.unwrap))(
        _.eventResourceType
      )
      .optionallyWith(
        eventTime.map(value => ConfigurationEventTime.unwrap(value): Instant)
      )(_.eventTime)
      .optionallyWith(
        eventDetail.map(value =>
          ConfigurationEventDetail.unwrap(value): java.lang.String
        )
      )(_.eventDetail)
      .optionallyWith(
        eventResourceName.map(value =>
          ConfigurationEventResourceName.unwrap(value): java.lang.String
        )
      )(_.eventResourceName)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly =
    zio.aws.applicationinsights.model.ConfigurationEvent.wrap(buildAwsValue())
}
object ConfigurationEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ConfigurationEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ConfigurationEvent =
      zio.aws.applicationinsights.model.ConfigurationEvent(
        resourceGroupName.map(value => value),
        accountId.map(value => value),
        monitoredResourceARN.map(value => value),
        eventStatus.map(value => value),
        eventResourceType.map(value => value),
        eventTime.map(value => value),
        eventDetail.map(value => value),
        eventResourceName.map(value => value)
      )
    def resourceGroupName: Optional[ResourceGroupName]
    def accountId: Optional[AccountId]
    def monitoredResourceARN: Optional[ConfigurationEventMonitoredResourceARN]
    def eventStatus
        : Optional[zio.aws.applicationinsights.model.ConfigurationEventStatus]
    def eventResourceType: Optional[
      zio.aws.applicationinsights.model.ConfigurationEventResourceType
    ]
    def eventTime: Optional[ConfigurationEventTime]
    def eventDetail: Optional[ConfigurationEventDetail]
    def eventResourceName: Optional[ConfigurationEventResourceName]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getMonitoredResourceARN
        : ZIO[Any, AwsError, ConfigurationEventMonitoredResourceARN] =
      AwsError.unwrapOptionField("monitoredResourceARN", monitoredResourceARN)
    def getEventStatus: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ConfigurationEventStatus
    ] = AwsError.unwrapOptionField("eventStatus", eventStatus)
    def getEventResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ConfigurationEventResourceType
    ] = AwsError.unwrapOptionField("eventResourceType", eventResourceType)
    def getEventTime: ZIO[Any, AwsError, ConfigurationEventTime] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getEventDetail: ZIO[Any, AwsError, ConfigurationEventDetail] =
      AwsError.unwrapOptionField("eventDetail", eventDetail)
    def getEventResourceName
        : ZIO[Any, AwsError, ConfigurationEventResourceName] =
      AwsError.unwrapOptionField("eventResourceName", eventResourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ConfigurationEvent
  ) extends zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly {
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
    override val monitoredResourceARN
        : Optional[ConfigurationEventMonitoredResourceARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoredResourceARN())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ConfigurationEventMonitoredResourceARN(value)
        )
    override val eventStatus
        : Optional[zio.aws.applicationinsights.model.ConfigurationEventStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventStatus())
        .map(value =>
          zio.aws.applicationinsights.model.ConfigurationEventStatus.wrap(value)
        )
    override val eventResourceType: Optional[
      zio.aws.applicationinsights.model.ConfigurationEventResourceType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventResourceType())
      .map(value =>
        zio.aws.applicationinsights.model.ConfigurationEventResourceType
          .wrap(value)
      )
    override val eventTime: Optional[ConfigurationEventTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTime())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ConfigurationEventTime(value)
        )
    override val eventDetail: Optional[ConfigurationEventDetail] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventDetail())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ConfigurationEventDetail(value)
        )
    override val eventResourceName: Optional[ConfigurationEventResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventResourceName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ConfigurationEventResourceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ConfigurationEvent
  ): zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly =
    new Wrapper(impl)
}
