package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait GroupingType {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.GroupingType
}
object GroupingType {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.GroupingType
  ): zio.aws.applicationinsights.model.GroupingType = value match {
    case software.amazon.awssdk.services.applicationinsights.model.GroupingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.GroupingType.ACCOUNT_BASED =>
      val r = ACCOUNT_BASED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.GroupingType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.GroupingType =
      software.amazon.awssdk.services.applicationinsights.model.GroupingType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT_BASED
      extends zio.aws.applicationinsights.model.GroupingType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.GroupingType =
      software.amazon.awssdk.services.applicationinsights.model.GroupingType.ACCOUNT_BASED
  }
}
