package zio.aws.applicationinsights.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  Insights,
  ProblemId,
  AffectedResource,
  RecurringCount,
  EndTime,
  StartTime,
  LastRecurrenceTime,
  ResourceGroupName,
  Title
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Problem(
    id: Optional[ProblemId] = Optional.Absent,
    title: Optional[Title] = Optional.Absent,
    insights: Optional[Insights] = Optional.Absent,
    status: Optional[zio.aws.applicationinsights.model.Status] =
      Optional.Absent,
    affectedResource: Optional[AffectedResource] = Optional.Absent,
    startTime: Optional[StartTime] = Optional.Absent,
    endTime: Optional[EndTime] = Optional.Absent,
    severityLevel: Optional[zio.aws.applicationinsights.model.SeverityLevel] =
      Optional.Absent,
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    feedback: Optional[Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]] = Optional.Absent,
    recurringCount: Optional[RecurringCount] = Optional.Absent,
    lastRecurrenceTime: Optional[LastRecurrenceTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.Problem = {
    import Problem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.Problem
      .builder()
      .optionallyWith(
        id.map(value => ProblemId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        title.map(value => Title.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        insights.map(value => Insights.unwrap(value): java.lang.String)
      )(_.insights)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        affectedResource.map(value =>
          AffectedResource.unwrap(value): java.lang.String
        )
      )(_.affectedResource)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(severityLevel.map(value => value.unwrap))(_.severityLevel)
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        feedback.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.unwrap.toString
            })
            .asJava
        )
      )(_.feedbackWithStrings)
      .optionallyWith(
        recurringCount.map(value =>
          RecurringCount.unwrap(value): java.lang.Long
        )
      )(_.recurringCount)
      .optionallyWith(
        lastRecurrenceTime.map(value =>
          LastRecurrenceTime.unwrap(value): Instant
        )
      )(_.lastRecurrenceTime)
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.Problem.ReadOnly =
    zio.aws.applicationinsights.model.Problem.wrap(buildAwsValue())
}
object Problem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.Problem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.Problem =
      zio.aws.applicationinsights.model.Problem(
        id.map(value => value),
        title.map(value => value),
        insights.map(value => value),
        status.map(value => value),
        affectedResource.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        severityLevel.map(value => value),
        resourceGroupName.map(value => value),
        feedback.map(value => value),
        recurringCount.map(value => value),
        lastRecurrenceTime.map(value => value)
      )
    def id: Optional[ProblemId]
    def title: Optional[Title]
    def insights: Optional[Insights]
    def status: Optional[zio.aws.applicationinsights.model.Status]
    def affectedResource: Optional[AffectedResource]
    def startTime: Optional[StartTime]
    def endTime: Optional[EndTime]
    def severityLevel: Optional[zio.aws.applicationinsights.model.SeverityLevel]
    def resourceGroupName: Optional[ResourceGroupName]
    def feedback: Optional[Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]]
    def recurringCount: Optional[RecurringCount]
    def lastRecurrenceTime: Optional[LastRecurrenceTime]
    def getId: ZIO[Any, AwsError, ProblemId] =
      AwsError.unwrapOptionField("id", id)
    def getTitle: ZIO[Any, AwsError, Title] =
      AwsError.unwrapOptionField("title", title)
    def getInsights: ZIO[Any, AwsError, Insights] =
      AwsError.unwrapOptionField("insights", insights)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getAffectedResource: ZIO[Any, AwsError, AffectedResource] =
      AwsError.unwrapOptionField("affectedResource", affectedResource)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSeverityLevel
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.SeverityLevel] =
      AwsError.unwrapOptionField("severityLevel", severityLevel)
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getFeedback: ZIO[Any, AwsError, Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]] = AwsError.unwrapOptionField("feedback", feedback)
    def getRecurringCount: ZIO[Any, AwsError, RecurringCount] =
      AwsError.unwrapOptionField("recurringCount", recurringCount)
    def getLastRecurrenceTime: ZIO[Any, AwsError, LastRecurrenceTime] =
      AwsError.unwrapOptionField("lastRecurrenceTime", lastRecurrenceTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.Problem
  ) extends zio.aws.applicationinsights.model.Problem.ReadOnly {
    override val id: Optional[ProblemId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ProblemId(value)
      )
    override val title: Optional[Title] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.applicationinsights.model.primitives.Title(value))
    override val insights: Optional[Insights] = zio.aws.core.internal
      .optionalFromNullable(impl.insights())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.Insights(value)
      )
    override val status: Optional[zio.aws.applicationinsights.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.applicationinsights.model.Status.wrap(value))
    override val affectedResource: Optional[AffectedResource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.affectedResource())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.AffectedResource(value)
        )
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StartTime(value)
      )
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.applicationinsights.model.primitives.EndTime(value))
    override val severityLevel
        : Optional[zio.aws.applicationinsights.model.SeverityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityLevel())
        .map(value =>
          zio.aws.applicationinsights.model.SeverityLevel.wrap(value)
        )
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val feedback: Optional[Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.feedback())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.applicationinsights.model.FeedbackKey.wrap(
              key
            ) -> zio.aws.applicationinsights.model.FeedbackValue.wrap(value)
          })
          .toMap
      )
    override val recurringCount: Optional[RecurringCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCount())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.RecurringCount(value)
        )
    override val lastRecurrenceTime: Optional[LastRecurrenceTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRecurrenceTime())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.LastRecurrenceTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.Problem
  ): zio.aws.applicationinsights.model.Problem.ReadOnly = new Wrapper(impl)
}
