package zio.aws.applicationinsights
import zio.aws.applicationinsights.model.ListApplicationsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.applicationinsights.model.{
  UpdateLogPatternRequest,
  DescribeProblemRequest,
  UpdateApplicationRequest,
  DescribeComponentConfigurationRecommendationRequest,
  DescribeComponentConfigurationRequest,
  DescribeProblemObservationsRequest,
  DeleteApplicationRequest,
  DeleteComponentRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DeleteLogPatternRequest,
  CreateComponentRequest,
  UpdateComponentConfigurationRequest,
  DescribeApplicationRequest,
  DescribeObservationRequest,
  DescribeComponentRequest,
  ListLogPatternSetsRequest,
  UntagResourceRequest,
  UpdateComponentRequest,
  ListApplicationsRequest,
  ListProblemsRequest,
  ListComponentsRequest,
  ListConfigurationHistoryRequest,
  DescribeLogPatternRequest,
  TagResourceRequest,
  ListLogPatternsRequest,
  CreateLogPatternRequest
}
import software.amazon.awssdk.services.applicationinsights.model.{
  CreateComponentResponse,
  UpdateComponentResponse,
  ListLogPatternSetsResponse,
  DeleteLogPatternResponse,
  UpdateLogPatternResponse,
  ListConfigurationHistoryResponse,
  CreateLogPatternResponse,
  ApplicationInfo,
  DescribeComponentResponse,
  ConfigurationEvent,
  DescribeApplicationResponse,
  UpdateApplicationResponse,
  ApplicationComponent,
  DeleteComponentResponse,
  UpdateComponentConfigurationResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListApplicationsResponse,
  Problem,
  DescribeComponentConfigurationResponse,
  CreateApplicationResponse,
  LogPattern,
  DescribeProblemObservationsResponse,
  DescribeComponentConfigurationRecommendationResponse,
  ListProblemsResponse,
  DescribeLogPatternResponse,
  ListLogPatternsResponse,
  DescribeObservationResponse,
  ListComponentsResponse,
  DescribeProblemResponse,
  TagResourceResponse,
  DeleteApplicationResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.applicationinsights.model.primitives.LogPatternSetName
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.applicationinsights.{
  ApplicationInsightsAsyncClientBuilder,
  ApplicationInsightsAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait ApplicationInsights extends AspectSupport[ApplicationInsights] {
  val api: ApplicationInsightsAsyncClient
  def deleteApplication(request: DeleteApplicationRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DeleteApplicationResponse.ReadOnly
  ]
  def updateLogPattern(request: UpdateLogPatternRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly
  ]
  def describeProblem(request: DescribeProblemRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly
  ]
  def describeLogPattern(request: DescribeLogPatternRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly
  ]
  def describeApplication(request: DescribeApplicationRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly
  ]
  def createApplication(request: CreateApplicationRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly
  ]
  def listLogPatternSets(
      request: ListLogPatternSetsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly,
    LogPatternSetName
  ]]
  def listLogPatternSetsPaginated(request: ListLogPatternSetsRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly
  ]
  def describeObservation(request: DescribeObservationRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly
  ]
  def describeComponent(request: DescribeComponentRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly
  ]
  def createLogPattern(request: CreateLogPatternRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly
  ]
  def listComponents(request: ListComponentsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
  ]
  def listComponentsPaginated(request: ListComponentsRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.UntagResourceResponse.ReadOnly
  ]
  def deleteComponent(request: DeleteComponentRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DeleteComponentResponse.ReadOnly
  ]
  def deleteLogPattern(request: DeleteLogPatternRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.DeleteLogPatternResponse.ReadOnly
  ]
  def listConfigurationHistory(
      request: ListConfigurationHistoryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly
  ]
  def listConfigurationHistoryPaginated(
      request: ListConfigurationHistoryRequest
  ): IO[
    AwsError,
    zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly
  ]
  def createComponent(request: CreateComponentRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.CreateComponentResponse.ReadOnly
  ]
  def describeProblemObservations(
      request: DescribeProblemObservationsRequest
  ): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.TagResourceResponse.ReadOnly
  ]
  def listApplications(request: ListApplicationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
  ]
  def listApplicationsPaginated(
      request: ListApplicationsRequest
  ): IO[AwsError, ReadOnly]
  def updateComponentConfiguration(
      request: UpdateComponentConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.applicationinsights.model.UpdateComponentConfigurationResponse.ReadOnly
  ]
  def describeComponentConfiguration(
      request: DescribeComponentConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly
  ]
  def updateApplication(request: UpdateApplicationRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly
  ]
  def listProblems(
      request: ListProblemsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly,
    zio.aws.applicationinsights.model.Problem.ReadOnly
  ]]
  def listProblemsPaginated(request: ListProblemsRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly
  ]
  def listLogPatterns(
      request: ListLogPatternsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly,
    zio.aws.applicationinsights.model.LogPattern.ReadOnly
  ]]
  def listLogPatternsPaginated(request: ListLogPatternsRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly
  ]
  def updateComponent(request: UpdateComponentRequest): IO[
    AwsError,
    zio.aws.applicationinsights.model.UpdateComponentResponse.ReadOnly
  ]
  def describeComponentConfigurationRecommendation(
      request: DescribeComponentConfigurationRecommendationRequest
  ): IO[
    AwsError,
    zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly
  ]
}
object ApplicationInsights {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ApplicationInsights] =
    customized(identity)
  def customized(
      customization: ApplicationInsightsAsyncClientBuilder => ApplicationInsightsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ApplicationInsights] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ApplicationInsightsAsyncClientBuilder => ApplicationInsightsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ApplicationInsights] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ApplicationInsightsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      ApplicationInsightsAsyncClient,
      ApplicationInsightsAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      ApplicationInsightsAsyncClient,
      ApplicationInsightsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ApplicationInsightsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ApplicationInsightsImpl[R](
      override val api: ApplicationInsightsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ApplicationInsights
      with AwsServiceBase[R] {
    override val serviceName: String = "ApplicationInsights"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ApplicationInsightsImpl[R1] =
      new ApplicationInsightsImpl(api, newAspect, r)
    def deleteApplication(request: DeleteApplicationRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DeleteApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DeleteApplicationResponse.wrap)
      .provideEnvironment(r)
    def updateLogPattern(request: UpdateLogPatternRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest,
      UpdateLogPatternResponse
    ]("updateLogPattern", api.updateLogPattern)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.UpdateLogPatternResponse.wrap)
      .provideEnvironment(r)
    def describeProblem(request: DescribeProblemRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest,
      DescribeProblemResponse
    ]("describeProblem", api.describeProblem)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DescribeProblemResponse.wrap)
      .provideEnvironment(r)
    def describeLogPattern(request: DescribeLogPatternRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest,
      DescribeLogPatternResponse
    ]("describeLogPattern", api.describeLogPattern)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DescribeLogPatternResponse.wrap)
      .provideEnvironment(r)
    def describeApplication(request: DescribeApplicationRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest,
      DescribeApplicationResponse
    ]("describeApplication", api.describeApplication)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DescribeApplicationResponse.wrap)
      .provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def listLogPatternSets(
        request: ListLogPatternSetsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly,
      LogPatternSetName
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest,
      ListLogPatternSetsResponse,
      java.lang.String
    ](
      "listLogPatternSets",
      api.listLogPatternSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.logPatternSets().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.applicationinsights.model.ListLogPatternSetsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.applicationinsights.model.primitives
                .LogPatternSetName(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listLogPatternSetsPaginated(request: ListLogPatternSetsRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest,
      ListLogPatternSetsResponse
    ]("listLogPatternSets", api.listLogPatternSets)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.ListLogPatternSetsResponse.wrap)
      .provideEnvironment(r)
    def describeObservation(request: DescribeObservationRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest,
      DescribeObservationResponse
    ]("describeObservation", api.describeObservation)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DescribeObservationResponse.wrap)
      .provideEnvironment(r)
    def describeComponent(request: DescribeComponentRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest,
      DescribeComponentResponse
    ]("describeComponent", api.describeComponent)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DescribeComponentResponse.wrap)
      .provideEnvironment(r)
    def createLogPattern(request: CreateLogPatternRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest,
      CreateLogPatternResponse
    ]("createLogPattern", api.createLogPattern)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.CreateLogPatternResponse.wrap)
      .provideEnvironment(r)
    def listComponents(request: ListComponentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest,
      ListComponentsResponse,
      ApplicationComponent
    ](
      "listComponents",
      api.listComponents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationComponentList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.applicationinsights.model.ApplicationComponent.wrap(item)
      )
      .provideEnvironment(r)
    def listComponentsPaginated(request: ListComponentsRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest,
      ListComponentsResponse
    ]("listComponents", api.listComponents)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.ListComponentsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteComponent(request: DeleteComponentRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DeleteComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest,
      DeleteComponentResponse
    ]("deleteComponent", api.deleteComponent)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DeleteComponentResponse.wrap)
      .provideEnvironment(r)
    def deleteLogPattern(request: DeleteLogPatternRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.DeleteLogPatternResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest,
      DeleteLogPatternResponse
    ]("deleteLogPattern", api.deleteLogPattern)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.DeleteLogPatternResponse.wrap)
      .provideEnvironment(r)
    def listConfigurationHistory(
        request: ListConfigurationHistoryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest,
      ListConfigurationHistoryResponse,
      ConfigurationEvent
    ](
      "listConfigurationHistory",
      api.listConfigurationHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.eventList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.applicationinsights.model.ConfigurationEvent.wrap(item)
      )
      .provideEnvironment(r)
    def listConfigurationHistoryPaginated(
        request: ListConfigurationHistoryRequest
    ): IO[
      AwsError,
      zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest,
      ListConfigurationHistoryResponse
    ]("listConfigurationHistory", api.listConfigurationHistory)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.wrap
    ).provideEnvironment(r)
    def createComponent(request: CreateComponentRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.CreateComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest,
      CreateComponentResponse
    ]("createComponent", api.createComponent)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.CreateComponentResponse.wrap)
      .provideEnvironment(r)
    def describeProblemObservations(
        request: DescribeProblemObservationsRequest
    ): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest,
      DescribeProblemObservationsResponse
    ]("describeProblemObservations", api.describeProblemObservations)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.wrap
    ).provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def listApplications(request: ListApplicationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest,
      ListApplicationsResponse,
      ApplicationInfo
    ](
      "listApplications",
      api.listApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationInfoList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.applicationinsights.model.ApplicationInfo.wrap(item))
      .provideEnvironment(r)
    def listApplicationsPaginated(
        request: ListApplicationsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest,
      ListApplicationsResponse
    ]("listApplications", api.listApplications)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.ListApplicationsResponse.wrap)
      .provideEnvironment(r)
    def updateComponentConfiguration(
        request: UpdateComponentConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.applicationinsights.model.UpdateComponentConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest,
      UpdateComponentConfigurationResponse
    ]("updateComponentConfiguration", api.updateComponentConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationinsights.model.UpdateComponentConfigurationResponse.wrap
    ).provideEnvironment(r)
    def describeComponentConfiguration(
        request: DescribeComponentConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest,
      DescribeComponentConfigurationResponse
    ]("describeComponentConfiguration", api.describeComponentConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.wrap
    ).provideEnvironment(r)
    def updateApplication(request: UpdateApplicationRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.UpdateApplicationResponse.wrap)
      .provideEnvironment(r)
    def listProblems(
        request: ListProblemsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly,
      zio.aws.applicationinsights.model.Problem.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest,
      ListProblemsResponse,
      Problem
    ](
      "listProblems",
      api.listProblems,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.problemList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.applicationinsights.model.ListProblemsResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.applicationinsights.model.Problem.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listProblemsPaginated(request: ListProblemsRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest,
      ListProblemsResponse
    ]("listProblems", api.listProblems)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.ListProblemsResponse.wrap)
      .provideEnvironment(r)
    def listLogPatterns(
        request: ListLogPatternsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly,
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest,
      ListLogPatternsResponse,
      LogPattern
    ](
      "listLogPatterns",
      api.listLogPatterns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.logPatterns().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.applicationinsights.model.ListLogPatternsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.applicationinsights.model.LogPattern.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listLogPatternsPaginated(request: ListLogPatternsRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest,
      ListLogPatternsResponse
    ]("listLogPatterns", api.listLogPatterns)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.ListLogPatternsResponse.wrap)
      .provideEnvironment(r)
    def updateComponent(request: UpdateComponentRequest): IO[
      AwsError,
      zio.aws.applicationinsights.model.UpdateComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest,
      UpdateComponentResponse
    ]("updateComponent", api.updateComponent)(request.buildAwsValue())
      .map(zio.aws.applicationinsights.model.UpdateComponentResponse.wrap)
      .provideEnvironment(r)
    def describeComponentConfigurationRecommendation(
        request: DescribeComponentConfigurationRecommendationRequest
    ): IO[
      AwsError,
      zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest,
      DescribeComponentConfigurationRecommendationResponse
    ](
      "describeComponentConfigurationRecommendation",
      api.describeComponentConfigurationRecommendation
    )(request.buildAwsValue())
      .map(
        zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.wrap
      )
      .provideEnvironment(r)
  }
  def deleteApplication(request: DeleteApplicationRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def updateLogPattern(request: UpdateLogPatternRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLogPattern(request))
  def describeProblem(request: DescribeProblemRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProblem(request))
  def describeLogPattern(request: DescribeLogPatternRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLogPattern(request))
  def describeApplication(request: DescribeApplicationRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplication(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def listLogPatternSets(request: ListLogPatternSetsRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly,
      LogPatternSetName
    ]
  ] = ZIO.serviceWithZIO(_.listLogPatternSets(request))
  def listLogPatternSetsPaginated(request: ListLogPatternSetsRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLogPatternSetsPaginated(request))
  def describeObservation(request: DescribeObservationRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeObservation(request))
  def describeComponent(request: DescribeComponentRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeComponent(request))
  def createLogPattern(request: CreateLogPatternRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLogPattern(request))
  def listComponents(request: ListComponentsRequest): ZStream[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponents(request))
  def listComponentsPaginated(request: ListComponentsRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteComponent(request: DeleteComponentRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DeleteComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteComponent(request))
  def deleteLogPattern(request: DeleteLogPatternRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DeleteLogPatternResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLogPattern(request))
  def listConfigurationHistory(
      request: ListConfigurationHistoryRequest
  ): ZStream[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.listConfigurationHistory(request))
  def listConfigurationHistoryPaginated(
      request: ListConfigurationHistoryRequest
  ): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigurationHistoryPaginated(request))
  def createComponent(request: CreateComponentRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.CreateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComponent(request))
  def describeProblemObservations(
      request: DescribeProblemObservationsRequest
  ): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProblemObservations(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(request: ListApplicationsRequest): ZStream[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(
      request: ListApplicationsRequest
  ): ZIO[zio.aws.applicationinsights.ApplicationInsights, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def updateComponentConfiguration(
      request: UpdateComponentConfigurationRequest
  ): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.UpdateComponentConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComponentConfiguration(request))
  def describeComponentConfiguration(
      request: DescribeComponentConfigurationRequest
  ): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeComponentConfiguration(request))
  def updateApplication(request: UpdateApplicationRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def listProblems(request: ListProblemsRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly,
      zio.aws.applicationinsights.model.Problem.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listProblems(request))
  def listProblemsPaginated(request: ListProblemsRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProblemsPaginated(request))
  def listLogPatterns(request: ListLogPatternsRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly,
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listLogPatterns(request))
  def listLogPatternsPaginated(request: ListLogPatternsRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLogPatternsPaginated(request))
  def updateComponent(request: UpdateComponentRequest): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.UpdateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComponent(request))
  def describeComponentConfigurationRecommendation(
      request: DescribeComponentConfigurationRecommendationRequest
  ): ZIO[
    zio.aws.applicationinsights.ApplicationInsights,
    AwsError,
    zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeComponentConfigurationRecommendation(request))
}
