package zio.aws.applicationinsights
import zio.prelude.Subtype
import zio.aws.applicationinsights.model.primitives.{
  MetaDataKey,
  MetaDataValue,
  LogPatternSetName,
  ResourceARN,
  TagKey
}
import java.time.Instant
import zio.aws.applicationinsights.model.primitives.LogPatternRank.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AffectedResource extends Subtype[String]
    type AffectedResource =
      zio.aws.applicationinsights.model.primitives.AffectedResource.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.applicationinsights.model.primitives.AmazonResourceName.Type
    object AutoConfigEnabled extends Subtype[Boolean]
    type AutoConfigEnabled =
      zio.aws.applicationinsights.model.primitives.AutoConfigEnabled.Type
    object AutoCreate extends Subtype[Boolean]
    type AutoCreate =
      zio.aws.applicationinsights.model.primitives.AutoCreate.Type
    object CWEMonitorEnabled extends Subtype[Boolean]
    type CWEMonitorEnabled =
      zio.aws.applicationinsights.model.primitives.CWEMonitorEnabled.Type
    object CloudWatchEventDetailType extends Subtype[String]
    type CloudWatchEventDetailType =
      zio.aws.applicationinsights.model.primitives.CloudWatchEventDetailType.Type
    object CloudWatchEventId extends Subtype[String]
    type CloudWatchEventId =
      zio.aws.applicationinsights.model.primitives.CloudWatchEventId.Type
    object CodeDeployApplication extends Subtype[String]
    type CodeDeployApplication =
      zio.aws.applicationinsights.model.primitives.CodeDeployApplication.Type
    object CodeDeployDeploymentGroup extends Subtype[String]
    type CodeDeployDeploymentGroup =
      zio.aws.applicationinsights.model.primitives.CodeDeployDeploymentGroup.Type
    object CodeDeployDeploymentId extends Subtype[String]
    type CodeDeployDeploymentId =
      zio.aws.applicationinsights.model.primitives.CodeDeployDeploymentId.Type
    object CodeDeployInstanceGroupId extends Subtype[String]
    type CodeDeployInstanceGroupId =
      zio.aws.applicationinsights.model.primitives.CodeDeployInstanceGroupId.Type
    object CodeDeployState extends Subtype[String]
    type CodeDeployState =
      zio.aws.applicationinsights.model.primitives.CodeDeployState.Type
    object ComponentConfiguration extends Subtype[String]
    type ComponentConfiguration =
      zio.aws.applicationinsights.model.primitives.ComponentConfiguration.Type
    object ComponentName extends Subtype[String]
    type ComponentName =
      zio.aws.applicationinsights.model.primitives.ComponentName.Type
    object ConfigurationEventDetail extends Subtype[String]
    type ConfigurationEventDetail =
      zio.aws.applicationinsights.model.primitives.ConfigurationEventDetail.Type
    object ConfigurationEventMonitoredResourceARN extends Subtype[String]
    type ConfigurationEventMonitoredResourceARN =
      zio.aws.applicationinsights.model.primitives.ConfigurationEventMonitoredResourceARN.Type
    object ConfigurationEventResourceName extends Subtype[String]
    type ConfigurationEventResourceName =
      zio.aws.applicationinsights.model.primitives.ConfigurationEventResourceName.Type
    object ConfigurationEventTime extends Subtype[Instant]
    type ConfigurationEventTime =
      zio.aws.applicationinsights.model.primitives.ConfigurationEventTime.Type
    object CustomComponentName extends Subtype[String]
    type CustomComponentName =
      zio.aws.applicationinsights.model.primitives.CustomComponentName.Type
    object EbsCause extends Subtype[String]
    type EbsCause = zio.aws.applicationinsights.model.primitives.EbsCause.Type
    object EbsEvent extends Subtype[String]
    type EbsEvent = zio.aws.applicationinsights.model.primitives.EbsEvent.Type
    object EbsRequestId extends Subtype[String]
    type EbsRequestId =
      zio.aws.applicationinsights.model.primitives.EbsRequestId.Type
    object EbsResult extends Subtype[String]
    type EbsResult = zio.aws.applicationinsights.model.primitives.EbsResult.Type
    object Ec2State extends Subtype[String]
    type Ec2State = zio.aws.applicationinsights.model.primitives.Ec2State.Type
    object EndTime extends Subtype[Instant]
    type EndTime = zio.aws.applicationinsights.model.primitives.EndTime.Type
    object HealthEventArn extends Subtype[String]
    type HealthEventArn =
      zio.aws.applicationinsights.model.primitives.HealthEventArn.Type
    object HealthEventDescription extends Subtype[String]
    type HealthEventDescription =
      zio.aws.applicationinsights.model.primitives.HealthEventDescription.Type
    object HealthEventTypeCategory extends Subtype[String]
    type HealthEventTypeCategory =
      zio.aws.applicationinsights.model.primitives.HealthEventTypeCategory.Type
    object HealthEventTypeCode extends Subtype[String]
    type HealthEventTypeCode =
      zio.aws.applicationinsights.model.primitives.HealthEventTypeCode.Type
    object HealthService extends Subtype[String]
    type HealthService =
      zio.aws.applicationinsights.model.primitives.HealthService.Type
    object Insights extends Subtype[String]
    type Insights = zio.aws.applicationinsights.model.primitives.Insights.Type
    object LastRecurrenceTime extends Subtype[Instant]
    type LastRecurrenceTime =
      zio.aws.applicationinsights.model.primitives.LastRecurrenceTime.Type
    object LifeCycle extends Subtype[String]
    type LifeCycle = zio.aws.applicationinsights.model.primitives.LifeCycle.Type
    object LineTime extends Subtype[Instant]
    type LineTime = zio.aws.applicationinsights.model.primitives.LineTime.Type
    object LogGroup extends Subtype[String]
    type LogGroup = zio.aws.applicationinsights.model.primitives.LogGroup.Type
    object LogPatternName extends Subtype[String]
    type LogPatternName =
      zio.aws.applicationinsights.model.primitives.LogPatternName.Type
    object LogPatternRank extends Subtype[Int]
    type LogPatternRank =
      zio.aws.applicationinsights.model.primitives.LogPatternRank.Type
    object LogPatternRegex extends Subtype[String]
    type LogPatternRegex =
      zio.aws.applicationinsights.model.primitives.LogPatternRegex.Type
    object LogPatternSetName extends Subtype[String]
    type LogPatternSetName =
      zio.aws.applicationinsights.model.primitives.LogPatternSetName.Type
    object LogText extends Subtype[String]
    type LogText = zio.aws.applicationinsights.model.primitives.LogText.Type
    object MaxEntities extends Subtype[Int]
    type MaxEntities =
      zio.aws.applicationinsights.model.primitives.MaxEntities.Type
    object MetaDataKey extends Subtype[String]
    type MetaDataKey =
      zio.aws.applicationinsights.model.primitives.MetaDataKey.Type
    object MetaDataValue extends Subtype[String]
    type MetaDataValue =
      zio.aws.applicationinsights.model.primitives.MetaDataValue.Type
    object MetricName extends Subtype[String]
    type MetricName =
      zio.aws.applicationinsights.model.primitives.MetricName.Type
    object MetricNamespace extends Subtype[String]
    type MetricNamespace =
      zio.aws.applicationinsights.model.primitives.MetricNamespace.Type
    object Monitor extends Subtype[Boolean]
    type Monitor = zio.aws.applicationinsights.model.primitives.Monitor.Type
    object ObservationId extends Subtype[String]
    type ObservationId =
      zio.aws.applicationinsights.model.primitives.ObservationId.Type
    object OpsCenterEnabled extends Subtype[Boolean]
    type OpsCenterEnabled =
      zio.aws.applicationinsights.model.primitives.OpsCenterEnabled.Type
    object OpsItemSNSTopicArn extends Subtype[String]
    type OpsItemSNSTopicArn =
      zio.aws.applicationinsights.model.primitives.OpsItemSNSTopicArn.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.applicationinsights.model.primitives.PaginationToken.Type
    object ProblemId extends Subtype[String]
    type ProblemId = zio.aws.applicationinsights.model.primitives.ProblemId.Type
    object RdsEventCategories extends Subtype[String]
    type RdsEventCategories =
      zio.aws.applicationinsights.model.primitives.RdsEventCategories.Type
    object RdsEventMessage extends Subtype[String]
    type RdsEventMessage =
      zio.aws.applicationinsights.model.primitives.RdsEventMessage.Type
    object RecurringCount extends Subtype[Long]
    type RecurringCount =
      zio.aws.applicationinsights.model.primitives.RecurringCount.Type
    object Remarks extends Subtype[String]
    type Remarks = zio.aws.applicationinsights.model.primitives.Remarks.Type
    object RemoveSNSTopic extends Subtype[Boolean]
    type RemoveSNSTopic =
      zio.aws.applicationinsights.model.primitives.RemoveSNSTopic.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN =
      zio.aws.applicationinsights.model.primitives.ResourceARN.Type
    object ResourceGroupName extends Subtype[String]
    type ResourceGroupName =
      zio.aws.applicationinsights.model.primitives.ResourceGroupName.Type
    object ResourceType extends Subtype[String]
    type ResourceType =
      zio.aws.applicationinsights.model.primitives.ResourceType.Type
    object S3EventName extends Subtype[String]
    type S3EventName =
      zio.aws.applicationinsights.model.primitives.S3EventName.Type
    object SourceARN extends Subtype[String]
    type SourceARN = zio.aws.applicationinsights.model.primitives.SourceARN.Type
    object SourceType extends Subtype[String]
    type SourceType =
      zio.aws.applicationinsights.model.primitives.SourceType.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.applicationinsights.model.primitives.StartTime.Type
    object StatesArn extends Subtype[String]
    type StatesArn = zio.aws.applicationinsights.model.primitives.StatesArn.Type
    object StatesExecutionArn extends Subtype[String]
    type StatesExecutionArn =
      zio.aws.applicationinsights.model.primitives.StatesExecutionArn.Type
    object StatesInput extends Subtype[String]
    type StatesInput =
      zio.aws.applicationinsights.model.primitives.StatesInput.Type
    object StatesStatus extends Subtype[String]
    type StatesStatus =
      zio.aws.applicationinsights.model.primitives.StatesStatus.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.applicationinsights.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.applicationinsights.model.primitives.TagValue.Type
    object Title extends Subtype[String]
    type Title = zio.aws.applicationinsights.model.primitives.Title.Type
    object Unit extends Subtype[String]
    type Unit = zio.aws.applicationinsights.model.primitives.Unit.Type
    object Value extends Subtype[Double]
    type Value = zio.aws.applicationinsights.model.primitives.Value.Type
    object XRayErrorPercent extends Subtype[Int]
    type XRayErrorPercent =
      zio.aws.applicationinsights.model.primitives.XRayErrorPercent.Type
    object XRayFaultPercent extends Subtype[Int]
    type XRayFaultPercent =
      zio.aws.applicationinsights.model.primitives.XRayFaultPercent.Type
    object XRayNodeName extends Subtype[String]
    type XRayNodeName =
      zio.aws.applicationinsights.model.primitives.XRayNodeName.Type
    object XRayNodeType extends Subtype[String]
    type XRayNodeType =
      zio.aws.applicationinsights.model.primitives.XRayNodeType.Type
    object XRayRequestAverageLatency extends Subtype[Long]
    type XRayRequestAverageLatency =
      zio.aws.applicationinsights.model.primitives.XRayRequestAverageLatency.Type
    object XRayRequestCount extends Subtype[Int]
    type XRayRequestCount =
      zio.aws.applicationinsights.model.primitives.XRayRequestCount.Type
    object XRayThrottlePercent extends Subtype[Int]
    type XRayThrottlePercent =
      zio.aws.applicationinsights.model.primitives.XRayThrottlePercent.Type
  }
  type ApplicationComponentList =
    List[zio.aws.applicationinsights.model.ApplicationComponent]
  type ApplicationInfoList =
    List[zio.aws.applicationinsights.model.ApplicationInfo]
  type ConfigurationEventList =
    List[zio.aws.applicationinsights.model.ConfigurationEvent]
  type DetectedWorkload =
    Map[zio.aws.applicationinsights.model.Tier, Map[MetaDataKey, MetaDataValue]]
  type Feedback = Map[
    zio.aws.applicationinsights.model.FeedbackKey,
    zio.aws.applicationinsights.model.FeedbackValue
  ]
  type LogPatternList = List[zio.aws.applicationinsights.model.LogPattern]
  type LogPatternSetList = List[LogPatternSetName]
  type ObservationList = List[zio.aws.applicationinsights.model.Observation]
  type ProblemList = List[zio.aws.applicationinsights.model.Problem]
  type ResourceList = List[ResourceARN]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.applicationinsights.model.Tag]
  type WorkloadMetaData = Map[MetaDataKey, MetaDataValue]
}
