package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ResourceGroupName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLogPatternResponse(
    logPattern: Optional[zio.aws.applicationinsights.model.LogPattern] =
      Optional.Absent,
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse = {
    import CreateLogPatternResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
      .builder()
      .optionallyWith(logPattern.map(value => value.buildAwsValue()))(
        _.logPattern
      )
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly =
    zio.aws.applicationinsights.model.CreateLogPatternResponse
      .wrap(buildAwsValue())
}
object CreateLogPatternResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.CreateLogPatternResponse =
      zio.aws.applicationinsights.model.CreateLogPatternResponse(
        logPattern.map(value => value.asEditable),
        resourceGroupName.map(value => value)
      )
    def logPattern
        : Optional[zio.aws.applicationinsights.model.LogPattern.ReadOnly]
    def resourceGroupName: Optional[ResourceGroupName]
    def getLogPattern: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ] = AwsError.unwrapOptionField("logPattern", logPattern)
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
  ) extends zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly {
    override val logPattern
        : Optional[zio.aws.applicationinsights.model.LogPattern.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPattern())
        .map(value => zio.aws.applicationinsights.model.LogPattern.wrap(value))
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
  ): zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly =
    new Wrapper(impl)
}
