package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentName,
  MetaDataKey,
  MetaDataValue,
  Remarks,
  ResourceType,
  Monitor
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationComponent(
    componentName: Optional[ComponentName] = Optional.Absent,
    componentRemarks: Optional[Remarks] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    osType: Optional[zio.aws.applicationinsights.model.OsType] =
      Optional.Absent,
    tier: Optional[zio.aws.applicationinsights.model.Tier] = Optional.Absent,
    monitor: Optional[Monitor] = Optional.Absent,
    detectedWorkload: Optional[Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent = {
    import ApplicationComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
      .builder()
      .optionallyWith(
        componentName.map(value =>
          ComponentName.unwrap(value): java.lang.String
        )
      )(_.componentName)
      .optionallyWith(
        componentRemarks.map(value => Remarks.unwrap(value): java.lang.String)
      )(_.componentRemarks)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(osType.map(value => value.unwrap))(_.osType)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        monitor.map(value => Monitor.unwrap(value): java.lang.Boolean)
      )(_.monitor)
      .optionallyWith(
        detectedWorkload.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value
                .map({ case (key, value) =>
                  (MetaDataKey.unwrap(key): java.lang.String) -> (MetaDataValue
                    .unwrap(value): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.detectedWorkloadWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly =
    zio.aws.applicationinsights.model.ApplicationComponent.wrap(buildAwsValue())
}
object ApplicationComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ApplicationComponent =
      zio.aws.applicationinsights.model.ApplicationComponent(
        componentName.map(value => value),
        componentRemarks.map(value => value),
        resourceType.map(value => value),
        osType.map(value => value),
        tier.map(value => value),
        monitor.map(value => value),
        detectedWorkload.map(value => value)
      )
    def componentName: Optional[ComponentName]
    def componentRemarks: Optional[Remarks]
    def resourceType: Optional[ResourceType]
    def osType: Optional[zio.aws.applicationinsights.model.OsType]
    def tier: Optional[zio.aws.applicationinsights.model.Tier]
    def monitor: Optional[Monitor]
    def detectedWorkload: Optional[Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]]
    def getComponentName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getComponentRemarks: ZIO[Any, AwsError, Remarks] =
      AwsError.unwrapOptionField("componentRemarks", componentRemarks)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getOsType
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.OsType] =
      AwsError.unwrapOptionField("osType", osType)
    def getTier: ZIO[Any, AwsError, zio.aws.applicationinsights.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getMonitor: ZIO[Any, AwsError, Monitor] =
      AwsError.unwrapOptionField("monitor", monitor)
    def getDetectedWorkload: ZIO[Any, AwsError, Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]] = AwsError.unwrapOptionField("detectedWorkload", detectedWorkload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
  ) extends zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly {
    override val componentName: Optional[ComponentName] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ComponentName(value)
      )
    override val componentRemarks: Optional[Remarks] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRemarks())
      .map(value => zio.aws.applicationinsights.model.primitives.Remarks(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceType(value)
      )
    override val osType: Optional[zio.aws.applicationinsights.model.OsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.osType())
        .map(value => zio.aws.applicationinsights.model.OsType.wrap(value))
    override val tier: Optional[zio.aws.applicationinsights.model.Tier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tier())
        .map(value => zio.aws.applicationinsights.model.Tier.wrap(value))
    override val monitor: Optional[Monitor] = zio.aws.core.internal
      .optionalFromNullable(impl.monitor())
      .map(value => zio.aws.applicationinsights.model.primitives.Monitor(value))
    override val detectedWorkload: Optional[Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.detectedWorkload())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.applicationinsights.model.Tier.wrap(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.applicationinsights.model.primitives.MetaDataKey(
                  key
                ) -> zio.aws.applicationinsights.model.primitives
                  .MetaDataValue(value)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
  ): zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly =
    new Wrapper(impl)
}
