package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.ListTagsForResourceRequest =
      zio.aws.applicationinsights.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: AmazonResourceName
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest
  ) extends zio.aws.applicationinsights.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.applicationinsights.model.primitives
        .AmazonResourceName(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest
  ): zio.aws.applicationinsights.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
