package zio.aws.applicationinsights.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  LogPatternRank,
  LogPatternRegex,
  LogPatternName,
  LogPatternSetName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LogPattern(
    patternSetName: Optional[LogPatternSetName] = Optional.Absent,
    patternName: Optional[LogPatternName] = Optional.Absent,
    pattern: Optional[LogPatternRegex] = Optional.Absent,
    rank: Optional[LogPatternRank] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.LogPattern = {
    import LogPattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.LogPattern
      .builder()
      .optionallyWith(
        patternSetName.map(value =>
          LogPatternSetName.unwrap(value): java.lang.String
        )
      )(_.patternSetName)
      .optionallyWith(
        patternName.map(value => LogPatternName.unwrap(value): java.lang.String)
      )(_.patternName)
      .optionallyWith(
        pattern.map(value => LogPatternRegex.unwrap(value): java.lang.String)
      )(_.pattern)
      .optionallyWith(rank.map(value => LogPatternRank.unwrap(value): Integer))(
        _.rank
      )
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.LogPattern.ReadOnly =
    zio.aws.applicationinsights.model.LogPattern.wrap(buildAwsValue())
}
object LogPattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.LogPattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.LogPattern =
      zio.aws.applicationinsights.model.LogPattern(
        patternSetName.map(value => value),
        patternName.map(value => value),
        pattern.map(value => value),
        rank.map(value => value)
      )
    def patternSetName: Optional[LogPatternSetName]
    def patternName: Optional[LogPatternName]
    def pattern: Optional[LogPatternRegex]
    def rank: Optional[LogPatternRank]
    def getPatternSetName: ZIO[Any, AwsError, LogPatternSetName] =
      AwsError.unwrapOptionField("patternSetName", patternSetName)
    def getPatternName: ZIO[Any, AwsError, LogPatternName] =
      AwsError.unwrapOptionField("patternName", patternName)
    def getPattern: ZIO[Any, AwsError, LogPatternRegex] =
      AwsError.unwrapOptionField("pattern", pattern)
    def getRank: ZIO[Any, AwsError, LogPatternRank] =
      AwsError.unwrapOptionField("rank", rank)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.LogPattern
  ) extends zio.aws.applicationinsights.model.LogPattern.ReadOnly {
    override val patternSetName: Optional[LogPatternSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patternSetName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.LogPatternSetName(value)
        )
    override val patternName: Optional[LogPatternName] = zio.aws.core.internal
      .optionalFromNullable(impl.patternName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternName(value)
      )
    override val pattern: Optional[LogPatternRegex] = zio.aws.core.internal
      .optionalFromNullable(impl.pattern())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternRegex(value)
      )
    override val rank: Optional[LogPatternRank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternRank(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.LogPattern
  ): zio.aws.applicationinsights.model.LogPattern.ReadOnly = new Wrapper(impl)
}
