package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  PaginationToken,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLogPatternsResponse(
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    logPatterns: Optional[
      Iterable[zio.aws.applicationinsights.model.LogPattern]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse = {
    import ListLogPatternsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        logPatterns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logPatterns)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListLogPatternsResponse
      .wrap(buildAwsValue())
}
object ListLogPatternsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListLogPatternsResponse =
      zio.aws.applicationinsights.model.ListLogPatternsResponse(
        resourceGroupName.map(value => value),
        logPatterns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceGroupName: Optional[ResourceGroupName]
    def logPatterns
        : Optional[List[zio.aws.applicationinsights.model.LogPattern.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getLogPatterns: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ]] = AwsError.unwrapOptionField("logPatterns", logPatterns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
  ) extends zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly {
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val logPatterns: Optional[
      List[zio.aws.applicationinsights.model.LogPattern.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationinsights.model.LogPattern.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
  ): zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly =
    new Wrapper(impl)
}
