package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeComponentConfigurationRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest = {
    import DescribeComponentConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeComponentConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest =
      zio.aws.applicationinsights.model
        .DescribeComponentConfigurationRequest(resourceGroupName, componentName)
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
  ) extends zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
  ): zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
