package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  OpsItemSNSTopicArn,
  AutoConfigEnabled,
  AutoCreate,
  ResourceGroupName,
  CWEMonitorEnabled,
  OpsCenterEnabled
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    opsCenterEnabled: Optional[OpsCenterEnabled] = Optional.Absent,
    cweMonitorEnabled: Optional[CWEMonitorEnabled] = Optional.Absent,
    opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.applicationinsights.model.Tag]] =
      Optional.Absent,
    autoConfigEnabled: Optional[AutoConfigEnabled] = Optional.Absent,
    autoCreate: Optional[AutoCreate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        opsCenterEnabled.map(value =>
          OpsCenterEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.opsCenterEnabled)
      .optionallyWith(
        cweMonitorEnabled.map(value =>
          CWEMonitorEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.cweMonitorEnabled)
      .optionallyWith(
        opsItemSNSTopicArn.map(value =>
          OpsItemSNSTopicArn.unwrap(value): java.lang.String
        )
      )(_.opsItemSNSTopicArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        autoConfigEnabled.map(value =>
          AutoConfigEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.autoConfigEnabled)
      .optionallyWith(
        autoCreate.map(value => AutoCreate.unwrap(value): java.lang.Boolean)
      )(_.autoCreate)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.CreateApplicationRequest.ReadOnly =
    zio.aws.applicationinsights.model.CreateApplicationRequest
      .wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.CreateApplicationRequest =
      zio.aws.applicationinsights.model.CreateApplicationRequest(
        resourceGroupName.map(value => value),
        opsCenterEnabled.map(value => value),
        cweMonitorEnabled.map(value => value),
        opsItemSNSTopicArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoConfigEnabled.map(value => value),
        autoCreate.map(value => value)
      )
    def resourceGroupName: Optional[ResourceGroupName]
    def opsCenterEnabled: Optional[OpsCenterEnabled]
    def cweMonitorEnabled: Optional[CWEMonitorEnabled]
    def opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn]
    def tags: Optional[List[zio.aws.applicationinsights.model.Tag.ReadOnly]]
    def autoConfigEnabled: Optional[AutoConfigEnabled]
    def autoCreate: Optional[AutoCreate]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getOpsCenterEnabled: ZIO[Any, AwsError, OpsCenterEnabled] =
      AwsError.unwrapOptionField("opsCenterEnabled", opsCenterEnabled)
    def getCweMonitorEnabled: ZIO[Any, AwsError, CWEMonitorEnabled] =
      AwsError.unwrapOptionField("cweMonitorEnabled", cweMonitorEnabled)
    def getOpsItemSNSTopicArn: ZIO[Any, AwsError, OpsItemSNSTopicArn] =
      AwsError.unwrapOptionField("opsItemSNSTopicArn", opsItemSNSTopicArn)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getAutoConfigEnabled: ZIO[Any, AwsError, AutoConfigEnabled] =
      AwsError.unwrapOptionField("autoConfigEnabled", autoConfigEnabled)
    def getAutoCreate: ZIO[Any, AwsError, AutoCreate] =
      AwsError.unwrapOptionField("autoCreate", autoCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest
  ) extends zio.aws.applicationinsights.model.CreateApplicationRequest.ReadOnly {
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val opsCenterEnabled: Optional[OpsCenterEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsCenterEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.OpsCenterEnabled(value)
        )
    override val cweMonitorEnabled: Optional[CWEMonitorEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cweMonitorEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.CWEMonitorEnabled(value)
        )
    override val opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsItemSNSTopicArn())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.OpsItemSNSTopicArn(value)
        )
    override val tags
        : Optional[List[zio.aws.applicationinsights.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationinsights.model.Tag.wrap(item)
          }.toList
        )
    override val autoConfigEnabled: Optional[AutoConfigEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoConfigEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.AutoConfigEnabled(value)
        )
    override val autoCreate: Optional[AutoCreate] = zio.aws.core.internal
      .optionalFromNullable(impl.autoCreate())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AutoCreate(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest
  ): zio.aws.applicationinsights.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
