package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ProblemId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProblemRequest(problemId: ProblemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest = {
    import DescribeProblemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
      .builder()
      .problemId(ProblemId.unwrap(problemId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeProblemRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeProblemRequest
      .wrap(buildAwsValue())
}
object DescribeProblemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DescribeProblemRequest =
      zio.aws.applicationinsights.model.DescribeProblemRequest(problemId)
    def problemId: ProblemId
    def getProblemId: ZIO[Any, Nothing, ProblemId] = ZIO.succeed(problemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
  ) extends zio.aws.applicationinsights.model.DescribeProblemRequest.ReadOnly {
    override val problemId: ProblemId =
      zio.aws.applicationinsights.model.primitives.ProblemId(impl.problemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
  ): zio.aws.applicationinsights.model.DescribeProblemRequest.ReadOnly =
    new Wrapper(impl)
}
