package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentConfiguration,
  Monitor
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComponentConfigurationResponse(
    monitor: Optional[Monitor] = Optional.Absent,
    tier: Optional[zio.aws.applicationinsights.model.Tier] = Optional.Absent,
    componentConfiguration: Optional[ComponentConfiguration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse = {
    import DescribeComponentConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
      .builder()
      .optionallyWith(
        monitor.map(value => Monitor.unwrap(value): java.lang.Boolean)
      )(_.monitor)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        componentConfiguration.map(value =>
          ComponentConfiguration.unwrap(value): java.lang.String
        )
      )(_.componentConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeComponentConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse =
      zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse(
        monitor.map(value => value),
        tier.map(value => value),
        componentConfiguration.map(value => value)
      )
    def monitor: Optional[Monitor]
    def tier: Optional[zio.aws.applicationinsights.model.Tier]
    def componentConfiguration: Optional[ComponentConfiguration]
    def getMonitor: ZIO[Any, AwsError, Monitor] =
      AwsError.unwrapOptionField("monitor", monitor)
    def getTier: ZIO[Any, AwsError, zio.aws.applicationinsights.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getComponentConfiguration: ZIO[Any, AwsError, ComponentConfiguration] =
      AwsError.unwrapOptionField(
        "componentConfiguration",
        componentConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
  ) extends zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly {
    override val monitor: Optional[Monitor] = zio.aws.core.internal
      .optionalFromNullable(impl.monitor())
      .map(value => zio.aws.applicationinsights.model.primitives.Monitor(value))
    override val tier: Optional[zio.aws.applicationinsights.model.Tier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tier())
        .map(value => zio.aws.applicationinsights.model.Tier.wrap(value))
    override val componentConfiguration: Optional[ComponentConfiguration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentConfiguration())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ComponentConfiguration(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
  ): zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
