package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ResourceGroupName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLogPatternResponse(
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    logPattern: Optional[zio.aws.applicationinsights.model.LogPattern] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternResponse = {
    import DescribeLogPatternResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternResponse
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(logPattern.map(value => value.buildAwsValue()))(
        _.logPattern
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeLogPatternResponse
      .wrap(buildAwsValue())
}
object DescribeLogPatternResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeLogPatternResponse =
      zio.aws.applicationinsights.model.DescribeLogPatternResponse(
        resourceGroupName.map(value => value),
        logPattern.map(value => value.asEditable)
      )
    def resourceGroupName: Optional[ResourceGroupName]
    def logPattern
        : Optional[zio.aws.applicationinsights.model.LogPattern.ReadOnly]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getLogPattern: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ] = AwsError.unwrapOptionField("logPattern", logPattern)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternResponse
  ) extends zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly {
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val logPattern
        : Optional[zio.aws.applicationinsights.model.LogPattern.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPattern())
        .map(value => zio.aws.applicationinsights.model.LogPattern.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternResponse
  ): zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly =
    new Wrapper(impl)
}
