package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeObservationResponse(
    observation: Option[zio.aws.applicationinsights.model.Observation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeObservationResponse = {
    import DescribeObservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeObservationResponse
      .builder()
      .optionallyWith(observation.map(value => value.buildAwsValue()))(
        _.observation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeObservationResponse
      .wrap(buildAwsValue())
}
object DescribeObservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeObservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeObservationResponse =
      zio.aws.applicationinsights.model
        .DescribeObservationResponse(observation.map(value => value.asEditable))
    def observation
        : Option[zio.aws.applicationinsights.model.Observation.ReadOnly]
    def getObservation: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.Observation.ReadOnly
    ] = AwsError.unwrapOptionField("observation", observation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeObservationResponse
  ) extends zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly {
    override val observation
        : Option[zio.aws.applicationinsights.model.Observation.ReadOnly] = scala
      .Option(impl.observation())
      .map(value => zio.aws.applicationinsights.model.Observation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeObservationResponse
  ): zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly =
    new Wrapper(impl)
}
