package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ResourceARN,
  CustomComponentName,
  ResourceGroupName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateComponentRequest(
    resourceGroupName: ResourceGroupName,
    componentName: CustomComponentName,
    resourceList: Iterable[ResourceARN]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest = {
    import CreateComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(
        CustomComponentName.unwrap(componentName): java.lang.String
      )
      .resourceList(resourceList.map { item =>
        ResourceARN.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.CreateComponentRequest.ReadOnly =
    zio.aws.applicationinsights.model.CreateComponentRequest
      .wrap(buildAwsValue())
}
object CreateComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.CreateComponentRequest =
      zio.aws.applicationinsights.model
        .CreateComponentRequest(resourceGroupName, componentName, resourceList)
    def resourceGroupName: ResourceGroupName
    def componentName: CustomComponentName
    def resourceList: List[ResourceARN]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, CustomComponentName] =
      ZIO.succeed(componentName)
    def getResourceList: ZIO[Any, Nothing, List[ResourceARN]] =
      ZIO.succeed(resourceList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest
  ) extends zio.aws.applicationinsights.model.CreateComponentRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: CustomComponentName =
      zio.aws.applicationinsights.model.primitives
        .CustomComponentName(impl.componentName())
    override val resourceList: List[ResourceARN] = impl
      .resourceList()
      .asScala
      .map { item =>
        zio.aws.applicationinsights.model.primitives.ResourceARN(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest
  ): zio.aws.applicationinsights.model.CreateComponentRequest.ReadOnly =
    new Wrapper(impl)
}
