package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationInfo: Option[zio.aws.applicationinsights.model.ApplicationInfo] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.CreateApplicationResponse
      .builder()
      .optionallyWith(applicationInfo.map(value => value.buildAwsValue()))(
        _.applicationInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly =
    zio.aws.applicationinsights.model.CreateApplicationResponse
      .wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.CreateApplicationResponse =
      zio.aws.applicationinsights.model.CreateApplicationResponse(
        applicationInfo.map(value => value.asEditable)
      )
    def applicationInfo
        : Option[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly]
    def getApplicationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("applicationInfo", applicationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateApplicationResponse
  ) extends zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly {
    override val applicationInfo
        : Option[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly] =
      scala
        .Option(impl.applicationInfo())
        .map(value =>
          zio.aws.applicationinsights.model.ApplicationInfo.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateApplicationResponse
  ): zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
