package zio.aws.applicationinsights.model
import java.lang.Integer
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  PaginationToken,
  MaxEntities
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListApplicationsRequest(
    maxResults: Option[MaxEntities] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxEntities.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListApplicationsRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListApplicationsRequest
      .wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListApplicationsRequest =
      zio.aws.applicationinsights.model.ListApplicationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxEntities]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxEntities] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
  ) extends zio.aws.applicationinsights.model.ListApplicationsRequest.ReadOnly {
    override val maxResults: Option[MaxEntities] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MaxEntities(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
  ): zio.aws.applicationinsights.model.ListApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
