package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentName,
  MetaDataKey,
  MetaDataValue,
  Remarks,
  ResourceType,
  Monitor
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationComponent(
    componentName: Option[ComponentName] = None,
    componentRemarks: Option[Remarks] = None,
    resourceType: Option[ResourceType] = None,
    osType: Option[zio.aws.applicationinsights.model.OsType] = None,
    tier: Option[zio.aws.applicationinsights.model.Tier] = None,
    monitor: Option[Monitor] = None,
    detectedWorkload: Option[Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent = {
    import ApplicationComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
      .builder()
      .optionallyWith(
        componentName.map(value =>
          ComponentName.unwrap(value): java.lang.String
        )
      )(_.componentName)
      .optionallyWith(
        componentRemarks.map(value => Remarks.unwrap(value): java.lang.String)
      )(_.componentRemarks)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(osType.map(value => value.unwrap))(_.osType)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        monitor.map(value => Monitor.unwrap(value): java.lang.Boolean)
      )(_.monitor)
      .optionallyWith(
        detectedWorkload.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value
                .map({ case (key, value) =>
                  (MetaDataKey.unwrap(key): java.lang.String) -> (MetaDataValue
                    .unwrap(value): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.detectedWorkloadWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly =
    zio.aws.applicationinsights.model.ApplicationComponent.wrap(buildAwsValue())
}
object ApplicationComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ApplicationComponent =
      zio.aws.applicationinsights.model.ApplicationComponent(
        componentName.map(value => value),
        componentRemarks.map(value => value),
        resourceType.map(value => value),
        osType.map(value => value),
        tier.map(value => value),
        monitor.map(value => value),
        detectedWorkload.map(value => value)
      )
    def componentName: Option[ComponentName]
    def componentRemarks: Option[Remarks]
    def resourceType: Option[ResourceType]
    def osType: Option[zio.aws.applicationinsights.model.OsType]
    def tier: Option[zio.aws.applicationinsights.model.Tier]
    def monitor: Option[Monitor]
    def detectedWorkload: Option[Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]]
    def getComponentName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getComponentRemarks: ZIO[Any, AwsError, Remarks] =
      AwsError.unwrapOptionField("componentRemarks", componentRemarks)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getOsType
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.OsType] =
      AwsError.unwrapOptionField("osType", osType)
    def getTier: ZIO[Any, AwsError, zio.aws.applicationinsights.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getMonitor: ZIO[Any, AwsError, Monitor] =
      AwsError.unwrapOptionField("monitor", monitor)
    def getDetectedWorkload: ZIO[Any, AwsError, Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]] = AwsError.unwrapOptionField("detectedWorkload", detectedWorkload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
  ) extends zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly {
    override val componentName: Option[ComponentName] = scala
      .Option(impl.componentName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ComponentName(value)
      )
    override val componentRemarks: Option[Remarks] = scala
      .Option(impl.componentRemarks())
      .map(value => zio.aws.applicationinsights.model.primitives.Remarks(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceType(value)
      )
    override val osType: Option[zio.aws.applicationinsights.model.OsType] =
      scala
        .Option(impl.osType())
        .map(value => zio.aws.applicationinsights.model.OsType.wrap(value))
    override val tier: Option[zio.aws.applicationinsights.model.Tier] = scala
      .Option(impl.tier())
      .map(value => zio.aws.applicationinsights.model.Tier.wrap(value))
    override val monitor: Option[Monitor] = scala
      .Option(impl.monitor())
      .map(value => zio.aws.applicationinsights.model.primitives.Monitor(value))
    override val detectedWorkload: Option[Map[
      zio.aws.applicationinsights.model.Tier,
      Map[MetaDataKey, MetaDataValue]
    ]] = scala
      .Option(impl.detectedWorkload())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.applicationinsights.model.Tier.wrap(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.applicationinsights.model.primitives.MetaDataKey(
                  key
                ) -> zio.aws.applicationinsights.model.primitives
                  .MetaDataValue(value)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent
  ): zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly =
    new Wrapper(impl)
}
