package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeApplicationResponse(
    applicationInfo: Option[zio.aws.applicationinsights.model.ApplicationInfo] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationResponse = {
    import DescribeApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationResponse
      .builder()
      .optionallyWith(applicationInfo.map(value => value.buildAwsValue()))(
        _.applicationInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeApplicationResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeApplicationResponse =
      zio.aws.applicationinsights.model.DescribeApplicationResponse(
        applicationInfo.map(value => value.asEditable)
      )
    def applicationInfo
        : Option[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly]
    def getApplicationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("applicationInfo", applicationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationResponse
  ) extends zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly {
    override val applicationInfo
        : Option[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly] =
      scala
        .Option(impl.applicationInfo())
        .map(value =>
          zio.aws.applicationinsights.model.ApplicationInfo.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationResponse
  ): zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
