package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[zio.aws.applicationinsights.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.ListTagsForResourceResponse =
      zio.aws.applicationinsights.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[List[zio.aws.applicationinsights.model.Tag.ReadOnly]]
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceResponse
  ) extends zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly {
    override val tags
        : Option[List[zio.aws.applicationinsights.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationinsights.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceResponse
  ): zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
