package zio.aws.applicationinsights.model
import java.lang.Integer
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  PaginationToken,
  MaxEntities,
  LogPatternSetName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLogPatternsRequest(
    resourceGroupName: ResourceGroupName,
    patternSetName: Option[LogPatternSetName] = None,
    maxResults: Option[MaxEntities] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest = {
    import ListLogPatternsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .optionallyWith(
        patternSetName.map(value =>
          LogPatternSetName.unwrap(value): java.lang.String
        )
      )(_.patternSetName)
      .optionallyWith(
        maxResults.map(value => MaxEntities.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListLogPatternsRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListLogPatternsRequest
      .wrap(buildAwsValue())
}
object ListLogPatternsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListLogPatternsRequest =
      zio.aws.applicationinsights.model.ListLogPatternsRequest(
        resourceGroupName,
        patternSetName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def patternSetName: Option[LogPatternSetName]
    def maxResults: Option[MaxEntities]
    def nextToken: Option[PaginationToken]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getPatternSetName: ZIO[Any, AwsError, LogPatternSetName] =
      AwsError.unwrapOptionField("patternSetName", patternSetName)
    def getMaxResults: ZIO[Any, AwsError, MaxEntities] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest
  ) extends zio.aws.applicationinsights.model.ListLogPatternsRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val patternSetName: Option[LogPatternSetName] = scala
      .Option(impl.patternSetName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternSetName(value)
      )
    override val maxResults: Option[MaxEntities] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MaxEntities(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest
  ): zio.aws.applicationinsights.model.ListLogPatternsRequest.ReadOnly =
    new Wrapper(impl)
}
