package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ResourceARN,
  CustomComponentName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateComponentRequest(
    resourceGroupName: ResourceGroupName,
    componentName: CustomComponentName,
    newComponentName: Option[CustomComponentName] = None,
    resourceList: Option[Iterable[ResourceARN]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest = {
    import UpdateComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(
        CustomComponentName.unwrap(componentName): java.lang.String
      )
      .optionallyWith(
        newComponentName.map(value =>
          CustomComponentName.unwrap(value): java.lang.String
        )
      )(_.newComponentName)
      .optionallyWith(
        resourceList.map(value =>
          value.map { item =>
            ResourceARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceList)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateComponentRequest.ReadOnly =
    zio.aws.applicationinsights.model.UpdateComponentRequest
      .wrap(buildAwsValue())
}
object UpdateComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.UpdateComponentRequest =
      zio.aws.applicationinsights.model.UpdateComponentRequest(
        resourceGroupName,
        componentName,
        newComponentName.map(value => value),
        resourceList.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def componentName: CustomComponentName
    def newComponentName: Option[CustomComponentName]
    def resourceList: Option[List[ResourceARN]]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, CustomComponentName] =
      ZIO.succeed(componentName)
    def getNewComponentName: ZIO[Any, AwsError, CustomComponentName] =
      AwsError.unwrapOptionField("newComponentName", newComponentName)
    def getResourceList: ZIO[Any, AwsError, List[ResourceARN]] =
      AwsError.unwrapOptionField("resourceList", resourceList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest
  ) extends zio.aws.applicationinsights.model.UpdateComponentRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: CustomComponentName =
      zio.aws.applicationinsights.model.primitives
        .CustomComponentName(impl.componentName())
    override val newComponentName: Option[CustomComponentName] = scala
      .Option(impl.newComponentName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.CustomComponentName(value)
      )
    override val resourceList: Option[List[ResourceARN]] = scala
      .Option(impl.resourceList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationinsights.model.primitives.ResourceARN(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest
  ): zio.aws.applicationinsights.model.UpdateComponentRequest.ReadOnly =
    new Wrapper(impl)
}
