package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeComponentRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest = {
    import DescribeComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentRequest
      .wrap(buildAwsValue())
}
object DescribeComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DescribeComponentRequest =
      zio.aws.applicationinsights.model
        .DescribeComponentRequest(resourceGroupName, componentName)
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
  ) extends zio.aws.applicationinsights.model.DescribeComponentRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
  ): zio.aws.applicationinsights.model.DescribeComponentRequest.ReadOnly =
    new Wrapper(impl)
}
