package zio.aws.applicationinsights.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  MaxEntities,
  EndTime,
  StartTime,
  PaginationToken,
  ResourceGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListConfigurationHistoryRequest(
    resourceGroupName: Option[ResourceGroupName] = None,
    startTime: Option[StartTime] = None,
    endTime: Option[EndTime] = None,
    eventStatus: Option[
      zio.aws.applicationinsights.model.ConfigurationEventStatus
    ] = None,
    maxResults: Option[MaxEntities] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest = {
    import ListConfigurationHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(eventStatus.map(value => value.unwrap))(_.eventStatus)
      .optionallyWith(
        maxResults.map(value => MaxEntities.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListConfigurationHistoryRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListConfigurationHistoryRequest
      .wrap(buildAwsValue())
}
object ListConfigurationHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.ListConfigurationHistoryRequest =
      zio.aws.applicationinsights.model.ListConfigurationHistoryRequest(
        resourceGroupName.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        eventStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceGroupName: Option[ResourceGroupName]
    def startTime: Option[StartTime]
    def endTime: Option[EndTime]
    def eventStatus
        : Option[zio.aws.applicationinsights.model.ConfigurationEventStatus]
    def maxResults: Option[MaxEntities]
    def nextToken: Option[PaginationToken]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEventStatus: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ConfigurationEventStatus
    ] = AwsError.unwrapOptionField("eventStatus", eventStatus)
    def getMaxResults: ZIO[Any, AwsError, MaxEntities] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
  ) extends zio.aws.applicationinsights.model.ListConfigurationHistoryRequest.ReadOnly {
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
    override val startTime: Option[StartTime] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StartTime(value)
      )
    override val endTime: Option[EndTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.applicationinsights.model.primitives.EndTime(value))
    override val eventStatus
        : Option[zio.aws.applicationinsights.model.ConfigurationEventStatus] =
      scala
        .Option(impl.eventStatus())
        .map(value =>
          zio.aws.applicationinsights.model.ConfigurationEventStatus.wrap(value)
        )
    override val maxResults: Option[MaxEntities] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MaxEntities(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
  ): zio.aws.applicationinsights.model.ListConfigurationHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
