package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentConfiguration,
  WorkloadName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WorkloadConfiguration(
    workloadName: Optional[WorkloadName] = Optional.Absent,
    tier: Optional[zio.aws.applicationinsights.model.Tier] = Optional.Absent,
    configuration: Optional[ComponentConfiguration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.WorkloadConfiguration = {
    import WorkloadConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.WorkloadConfiguration
      .builder()
      .optionallyWith(
        workloadName.map(value => WorkloadName.unwrap(value): java.lang.String)
      )(_.workloadName)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        configuration.map(value =>
          ComponentConfiguration.unwrap(value): java.lang.String
        )
      )(_.configuration)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly =
    zio.aws.applicationinsights.model.WorkloadConfiguration
      .wrap(buildAwsValue())
}
object WorkloadConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.WorkloadConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.WorkloadConfiguration =
      zio.aws.applicationinsights.model.WorkloadConfiguration(
        workloadName.map(value => value),
        tier.map(value => value),
        configuration.map(value => value)
      )
    def workloadName: Optional[WorkloadName]
    def tier: Optional[zio.aws.applicationinsights.model.Tier]
    def configuration: Optional[ComponentConfiguration]
    def getWorkloadName: ZIO[Any, AwsError, WorkloadName] =
      AwsError.unwrapOptionField("workloadName", workloadName)
    def getTier: ZIO[Any, AwsError, zio.aws.applicationinsights.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getConfiguration: ZIO[Any, AwsError, ComponentConfiguration] =
      AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.WorkloadConfiguration
  ) extends zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly {
    override val workloadName: Optional[WorkloadName] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.WorkloadName(value)
      )
    override val tier: Optional[zio.aws.applicationinsights.model.Tier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tier())
        .map(value => zio.aws.applicationinsights.model.Tier.wrap(value))
    override val configuration: Optional[ComponentConfiguration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ComponentConfiguration(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.WorkloadConfiguration
  ): zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly =
    new Wrapper(impl)
}
