package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait Visibility {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.Visibility
}
object Visibility {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.Visibility
  ): zio.aws.applicationinsights.model.Visibility = value match {
    case software.amazon.awssdk.services.applicationinsights.model.Visibility.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.Visibility.IGNORED =>
      val r = IGNORED
      r
    case software.amazon.awssdk.services.applicationinsights.model.Visibility.VISIBLE =>
      val r = VISIBLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.Visibility {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Visibility =
      software.amazon.awssdk.services.applicationinsights.model.Visibility.UNKNOWN_TO_SDK_VERSION
  }
  case object IGNORED extends zio.aws.applicationinsights.model.Visibility {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Visibility =
      software.amazon.awssdk.services.applicationinsights.model.Visibility.IGNORED
  }
  case object VISIBLE extends zio.aws.applicationinsights.model.Visibility {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Visibility =
      software.amazon.awssdk.services.applicationinsights.model.Visibility.VISIBLE
  }
}
