package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  WorkloadId,
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateWorkloadRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    workloadId: Optional[WorkloadId] = Optional.Absent,
    workloadConfiguration: zio.aws.applicationinsights.model.WorkloadConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadRequest = {
    import UpdateWorkloadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .optionallyWith(
        workloadId.map(value => WorkloadId.unwrap(value): java.lang.String)
      )(_.workloadId)
      .workloadConfiguration(workloadConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateWorkloadRequest.ReadOnly =
    zio.aws.applicationinsights.model.UpdateWorkloadRequest
      .wrap(buildAwsValue())
}
object UpdateWorkloadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.UpdateWorkloadRequest =
      zio.aws.applicationinsights.model.UpdateWorkloadRequest(
        resourceGroupName,
        componentName,
        workloadId.map(value => value),
        workloadConfiguration.asEditable
      )
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def workloadId: Optional[WorkloadId]
    def workloadConfiguration
        : zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getWorkloadId: ZIO[Any, AwsError, WorkloadId] =
      AwsError.unwrapOptionField("workloadId", workloadId)
    def getWorkloadConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ] = ZIO.succeed(workloadConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadRequest
  ) extends zio.aws.applicationinsights.model.UpdateWorkloadRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val workloadId: Optional[WorkloadId] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.WorkloadId(value)
      )
    override val workloadConfiguration
        : zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly =
      zio.aws.applicationinsights.model.WorkloadConfiguration
        .wrap(impl.workloadConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadRequest
  ): zio.aws.applicationinsights.model.UpdateWorkloadRequest.ReadOnly =
    new Wrapper(impl)
}
