package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  OpsItemSNSTopicArn,
  AutoConfigEnabled,
  RemoveSNSTopic,
  AttachMissingPermission,
  ResourceGroupName,
  CWEMonitorEnabled,
  OpsCenterEnabled
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    resourceGroupName: ResourceGroupName,
    opsCenterEnabled: Optional[OpsCenterEnabled] = Optional.Absent,
    cweMonitorEnabled: Optional[CWEMonitorEnabled] = Optional.Absent,
    opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn] = Optional.Absent,
    removeSNSTopic: Optional[RemoveSNSTopic] = Optional.Absent,
    autoConfigEnabled: Optional[AutoConfigEnabled] = Optional.Absent,
    attachMissingPermission: Optional[AttachMissingPermission] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .optionallyWith(
        opsCenterEnabled.map(value =>
          OpsCenterEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.opsCenterEnabled)
      .optionallyWith(
        cweMonitorEnabled.map(value =>
          CWEMonitorEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.cweMonitorEnabled)
      .optionallyWith(
        opsItemSNSTopicArn.map(value =>
          OpsItemSNSTopicArn.unwrap(value): java.lang.String
        )
      )(_.opsItemSNSTopicArn)
      .optionallyWith(
        removeSNSTopic.map(value =>
          RemoveSNSTopic.unwrap(value): java.lang.Boolean
        )
      )(_.removeSNSTopic)
      .optionallyWith(
        autoConfigEnabled.map(value =>
          AutoConfigEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.autoConfigEnabled)
      .optionallyWith(
        attachMissingPermission.map(value =>
          AttachMissingPermission.unwrap(value): java.lang.Boolean
        )
      )(_.attachMissingPermission)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.applicationinsights.model.UpdateApplicationRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.UpdateApplicationRequest =
      zio.aws.applicationinsights.model.UpdateApplicationRequest(
        resourceGroupName,
        opsCenterEnabled.map(value => value),
        cweMonitorEnabled.map(value => value),
        opsItemSNSTopicArn.map(value => value),
        removeSNSTopic.map(value => value),
        autoConfigEnabled.map(value => value),
        attachMissingPermission.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def opsCenterEnabled: Optional[OpsCenterEnabled]
    def cweMonitorEnabled: Optional[CWEMonitorEnabled]
    def opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn]
    def removeSNSTopic: Optional[RemoveSNSTopic]
    def autoConfigEnabled: Optional[AutoConfigEnabled]
    def attachMissingPermission: Optional[AttachMissingPermission]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getOpsCenterEnabled: ZIO[Any, AwsError, OpsCenterEnabled] =
      AwsError.unwrapOptionField("opsCenterEnabled", opsCenterEnabled)
    def getCweMonitorEnabled: ZIO[Any, AwsError, CWEMonitorEnabled] =
      AwsError.unwrapOptionField("cweMonitorEnabled", cweMonitorEnabled)
    def getOpsItemSNSTopicArn: ZIO[Any, AwsError, OpsItemSNSTopicArn] =
      AwsError.unwrapOptionField("opsItemSNSTopicArn", opsItemSNSTopicArn)
    def getRemoveSNSTopic: ZIO[Any, AwsError, RemoveSNSTopic] =
      AwsError.unwrapOptionField("removeSNSTopic", removeSNSTopic)
    def getAutoConfigEnabled: ZIO[Any, AwsError, AutoConfigEnabled] =
      AwsError.unwrapOptionField("autoConfigEnabled", autoConfigEnabled)
    def getAttachMissingPermission
        : ZIO[Any, AwsError, AttachMissingPermission] = AwsError
      .unwrapOptionField("attachMissingPermission", attachMissingPermission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
  ) extends zio.aws.applicationinsights.model.UpdateApplicationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val opsCenterEnabled: Optional[OpsCenterEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsCenterEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.OpsCenterEnabled(value)
        )
    override val cweMonitorEnabled: Optional[CWEMonitorEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cweMonitorEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.CWEMonitorEnabled(value)
        )
    override val opsItemSNSTopicArn: Optional[OpsItemSNSTopicArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsItemSNSTopicArn())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.OpsItemSNSTopicArn(value)
        )
    override val removeSNSTopic: Optional[RemoveSNSTopic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSNSTopic())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.RemoveSNSTopic(value)
        )
    override val autoConfigEnabled: Optional[AutoConfigEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoConfigEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.AutoConfigEnabled(value)
        )
    override val attachMissingPermission: Optional[AttachMissingPermission] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachMissingPermission())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .AttachMissingPermission(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
  ): zio.aws.applicationinsights.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
