package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWorkloadsResponse(
    workloadList: Optional[
      Iterable[zio.aws.applicationinsights.model.Workload]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse = {
    import ListWorkloadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse
      .builder()
      .optionallyWith(
        workloadList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workloadList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListWorkloadsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListWorkloadsResponse
      .wrap(buildAwsValue())
}
object ListWorkloadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListWorkloadsResponse =
      zio.aws.applicationinsights.model.ListWorkloadsResponse(
        workloadList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def workloadList
        : Optional[List[zio.aws.applicationinsights.model.Workload.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getWorkloadList: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.Workload.ReadOnly
    ]] = AwsError.unwrapOptionField("workloadList", workloadList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse
  ) extends zio.aws.applicationinsights.model.ListWorkloadsResponse.ReadOnly {
    override val workloadList
        : Optional[List[zio.aws.applicationinsights.model.Workload.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workloadList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationinsights.model.Workload.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse
  ): zio.aws.applicationinsights.model.ListWorkloadsResponse.ReadOnly =
    new Wrapper(impl)
}
