package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  AccountId,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeApplicationRequest(
    resourceGroupName: ResourceGroupName,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest = {
    import DescribeApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeApplicationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeApplicationRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeApplicationRequest =
      zio.aws.applicationinsights.model.DescribeApplicationRequest(
        resourceGroupName,
        accountId.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def accountId: Optional[AccountId]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
  ) extends zio.aws.applicationinsights.model.DescribeApplicationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
  ): zio.aws.applicationinsights.model.DescribeApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
