package zio.aws.applicationinsights
import zio.aws.applicationinsights.model.ListApplicationsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.applicationinsights.model.{
  UpdateLogPatternRequest,
  DescribeProblemRequest,
  UpdateApplicationRequest,
  DescribeComponentConfigurationRecommendationRequest,
  DescribeComponentConfigurationRequest,
  DescribeProblemObservationsRequest,
  DeleteApplicationRequest,
  RemoveWorkloadRequest,
  DeleteComponentRequest,
  ListWorkloadsRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DeleteLogPatternRequest,
  CreateComponentRequest,
  UpdateComponentConfigurationRequest,
  DescribeWorkloadRequest,
  DescribeApplicationRequest,
  DescribeObservationRequest,
  DescribeComponentRequest,
  UpdateWorkloadRequest,
  ListLogPatternSetsRequest,
  UntagResourceRequest,
  UpdateComponentRequest,
  ListApplicationsRequest,
  ListProblemsRequest,
  ListComponentsRequest,
  ListConfigurationHistoryRequest,
  AddWorkloadRequest,
  DescribeLogPatternRequest,
  TagResourceRequest,
  ListLogPatternsRequest,
  UpdateProblemRequest,
  CreateLogPatternRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.applicationinsights.model.primitives.LogPatternSetName
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsAsyncClient
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ApplicationInsightsMock extends Mock[ApplicationInsights] {
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.applicationinsights.model.DeleteApplicationResponse.ReadOnly
      ]
  object ListWorkloads
      extends Stream[
        ListWorkloadsRequest,
        AwsError,
        zio.aws.applicationinsights.model.Workload.ReadOnly
      ]
  object ListWorkloadsPaginated
      extends Effect[
        ListWorkloadsRequest,
        AwsError,
        zio.aws.applicationinsights.model.ListWorkloadsResponse.ReadOnly
      ]
  object UpdateLogPattern
      extends Effect[
        UpdateLogPatternRequest,
        AwsError,
        zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly
      ]
  object DescribeWorkload
      extends Effect[
        DescribeWorkloadRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeWorkloadResponse.ReadOnly
      ]
  object DescribeProblem
      extends Effect[
        DescribeProblemRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly
      ]
  object DescribeLogPattern
      extends Effect[
        DescribeLogPatternRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly
      ]
  object DescribeApplication
      extends Effect[
        DescribeApplicationRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly
      ]
  object ListLogPatternSets
      extends Effect[ListLogPatternSetsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly,
        LogPatternSetName
      ]]
  object ListLogPatternSetsPaginated
      extends Effect[
        ListLogPatternSetsRequest,
        AwsError,
        zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly
      ]
  object DescribeObservation
      extends Effect[
        DescribeObservationRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly
      ]
  object UpdateProblem
      extends Effect[
        UpdateProblemRequest,
        AwsError,
        zio.aws.applicationinsights.model.UpdateProblemResponse.ReadOnly
      ]
  object AddWorkload
      extends Effect[
        AddWorkloadRequest,
        AwsError,
        zio.aws.applicationinsights.model.AddWorkloadResponse.ReadOnly
      ]
  object DescribeComponent
      extends Effect[
        DescribeComponentRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly
      ]
  object CreateLogPattern
      extends Effect[
        CreateLogPatternRequest,
        AwsError,
        zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly
      ]
  object ListComponents
      extends Stream[
        ListComponentsRequest,
        AwsError,
        zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
      ]
  object ListComponentsPaginated
      extends Effect[
        ListComponentsRequest,
        AwsError,
        zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.applicationinsights.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateWorkload
      extends Effect[
        UpdateWorkloadRequest,
        AwsError,
        zio.aws.applicationinsights.model.UpdateWorkloadResponse.ReadOnly
      ]
  object DeleteComponent
      extends Effect[
        DeleteComponentRequest,
        AwsError,
        zio.aws.applicationinsights.model.DeleteComponentResponse.ReadOnly
      ]
  object DeleteLogPattern
      extends Effect[
        DeleteLogPatternRequest,
        AwsError,
        zio.aws.applicationinsights.model.DeleteLogPatternResponse.ReadOnly
      ]
  object ListConfigurationHistory
      extends Stream[
        ListConfigurationHistoryRequest,
        AwsError,
        zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly
      ]
  object ListConfigurationHistoryPaginated
      extends Effect[
        ListConfigurationHistoryRequest,
        AwsError,
        zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly
      ]
  object CreateComponent
      extends Effect[
        CreateComponentRequest,
        AwsError,
        zio.aws.applicationinsights.model.CreateComponentResponse.ReadOnly
      ]
  object DescribeProblemObservations
      extends Effect[
        DescribeProblemObservationsRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.applicationinsights.model.TagResourceResponse.ReadOnly
      ]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[ListApplicationsRequest, AwsError, ReadOnly]
  object UpdateComponentConfiguration
      extends Effect[
        UpdateComponentConfigurationRequest,
        AwsError,
        zio.aws.applicationinsights.model.UpdateComponentConfigurationResponse.ReadOnly
      ]
  object DescribeComponentConfiguration
      extends Effect[
        DescribeComponentConfigurationRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly
      ]
  object ListProblems
      extends Effect[ListProblemsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly,
        zio.aws.applicationinsights.model.Problem.ReadOnly
      ]]
  object ListProblemsPaginated
      extends Effect[
        ListProblemsRequest,
        AwsError,
        zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly
      ]
  object ListLogPatterns
      extends Effect[ListLogPatternsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly,
        zio.aws.applicationinsights.model.LogPattern.ReadOnly
      ]]
  object ListLogPatternsPaginated
      extends Effect[
        ListLogPatternsRequest,
        AwsError,
        zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly
      ]
  object UpdateComponent
      extends Effect[
        UpdateComponentRequest,
        AwsError,
        zio.aws.applicationinsights.model.UpdateComponentResponse.ReadOnly
      ]
  object DescribeComponentConfigurationRecommendation
      extends Effect[
        DescribeComponentConfigurationRecommendationRequest,
        AwsError,
        zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly
      ]
  object RemoveWorkload
      extends Effect[
        RemoveWorkloadRequest,
        AwsError,
        zio.aws.applicationinsights.model.RemoveWorkloadResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ApplicationInsights] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ApplicationInsights] { rts =>
        ZIO.succeed {
          new ApplicationInsights {
            val api: ApplicationInsightsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ApplicationInsights = this
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def listWorkloads(request: ListWorkloadsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.applicationinsights.model.Workload.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkloads, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkloadsPaginated(request: ListWorkloadsRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.ListWorkloadsResponse.ReadOnly
            ] = proxy(ListWorkloadsPaginated, request)
            def updateLogPattern(request: UpdateLogPatternRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly
            ] = proxy(UpdateLogPattern, request)
            def describeWorkload(request: DescribeWorkloadRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeWorkloadResponse.ReadOnly
            ] = proxy(DescribeWorkload, request)
            def describeProblem(request: DescribeProblemRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly
            ] = proxy(DescribeProblem, request)
            def describeLogPattern(request: DescribeLogPatternRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeLogPatternResponse.ReadOnly
            ] = proxy(DescribeLogPattern, request)
            def describeApplication(request: DescribeApplicationRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeApplicationResponse.ReadOnly
            ] = proxy(DescribeApplication, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def listLogPatternSets(
                request: ListLogPatternSetsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly,
              LogPatternSetName
            ]] = proxy(ListLogPatternSets, request)
            def listLogPatternSetsPaginated(
                request: ListLogPatternSetsRequest
            ): IO[
              AwsError,
              zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly
            ] = proxy(ListLogPatternSetsPaginated, request)
            def describeObservation(request: DescribeObservationRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeObservationResponse.ReadOnly
            ] = proxy(DescribeObservation, request)
            def updateProblem(request: UpdateProblemRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.UpdateProblemResponse.ReadOnly
            ] = proxy(UpdateProblem, request)
            def addWorkload(request: AddWorkloadRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.AddWorkloadResponse.ReadOnly
            ] = proxy(AddWorkload, request)
            def describeComponent(request: DescribeComponentRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly
            ] = proxy(DescribeComponent, request)
            def createLogPattern(request: CreateLogPatternRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly
            ] = proxy(CreateLogPattern, request)
            def listComponents(request: ListComponentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComponentsPaginated(request: ListComponentsRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly
            ] = proxy(ListComponentsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def updateWorkload(request: UpdateWorkloadRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.UpdateWorkloadResponse.ReadOnly
            ] = proxy(UpdateWorkload, request)
            def deleteComponent(request: DeleteComponentRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DeleteComponentResponse.ReadOnly
            ] = proxy(DeleteComponent, request)
            def deleteLogPattern(request: DeleteLogPatternRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.DeleteLogPatternResponse.ReadOnly
            ] = proxy(DeleteLogPattern, request)
            def listConfigurationHistory(
                request: ListConfigurationHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConfigurationHistory, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConfigurationHistoryPaginated(
                request: ListConfigurationHistoryRequest
            ): IO[
              AwsError,
              zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly
            ] = proxy(ListConfigurationHistoryPaginated, request)
            def createComponent(request: CreateComponentRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.CreateComponentResponse.ReadOnly
            ] = proxy(CreateComponent, request)
            def describeProblemObservations(
                request: DescribeProblemObservationsRequest
            ): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly
            ] = proxy(DescribeProblemObservations, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(
                request: ListApplicationsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListApplicationsPaginated, request)
            def updateComponentConfiguration(
                request: UpdateComponentConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.applicationinsights.model.UpdateComponentConfigurationResponse.ReadOnly
            ] = proxy(UpdateComponentConfiguration, request)
            def describeComponentConfiguration(
                request: DescribeComponentConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly
            ] = proxy(DescribeComponentConfiguration, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def listProblems(
                request: ListProblemsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly,
              zio.aws.applicationinsights.model.Problem.ReadOnly
            ]] = proxy(ListProblems, request)
            def listProblemsPaginated(request: ListProblemsRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly
            ] = proxy(ListProblemsPaginated, request)
            def listLogPatterns(
                request: ListLogPatternsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly,
              zio.aws.applicationinsights.model.LogPattern.ReadOnly
            ]] = proxy(ListLogPatterns, request)
            def listLogPatternsPaginated(request: ListLogPatternsRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly
            ] = proxy(ListLogPatternsPaginated, request)
            def updateComponent(request: UpdateComponentRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.UpdateComponentResponse.ReadOnly
            ] = proxy(UpdateComponent, request)
            def describeComponentConfigurationRecommendation(
                request: DescribeComponentConfigurationRecommendationRequest
            ): IO[
              AwsError,
              zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly
            ] = proxy(DescribeComponentConfigurationRecommendation, request)
            def removeWorkload(request: RemoveWorkloadRequest): IO[
              AwsError,
              zio.aws.applicationinsights.model.RemoveWorkloadResponse.ReadOnly
            ] = proxy(RemoveWorkload, request)
          }
        }
      }
    }
  }
}
