package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait ConfigurationEventResourceType {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType
}
object ConfigurationEventResourceType {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType
  ): zio.aws.applicationinsights.model.ConfigurationEventResourceType =
    value match {
      case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.CLOUDWATCH_ALARM =>
        val r = CLOUDWATCH_ALARM
        r
      case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.CLOUDWATCH_LOG =>
        val r = CLOUDWATCH_LOG
        r
      case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.CLOUDFORMATION =>
        val r = CLOUDFORMATION
        r
      case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.SSM_ASSOCIATION =>
        val r = SSM_ASSOCIATION
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.ConfigurationEventResourceType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUDWATCH_ALARM
      extends zio.aws.applicationinsights.model.ConfigurationEventResourceType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.CLOUDWATCH_ALARM
  }
  case object CLOUDWATCH_LOG
      extends zio.aws.applicationinsights.model.ConfigurationEventResourceType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.CLOUDWATCH_LOG
  }
  case object CLOUDFORMATION
      extends zio.aws.applicationinsights.model.ConfigurationEventResourceType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.CLOUDFORMATION
  }
  case object SSM_ASSOCIATION
      extends zio.aws.applicationinsights.model.ConfigurationEventResourceType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType.SSM_ASSOCIATION
  }
}
