package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait SeverityLevel {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.SeverityLevel
}
object SeverityLevel {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.SeverityLevel
  ): zio.aws.applicationinsights.model.SeverityLevel = value match {
    case software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.INFORMATIVE =>
      val r = Informative
      r
    case software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.HIGH =>
      val r = High
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.SeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.SeverityLevel =
      software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object Informative
      extends zio.aws.applicationinsights.model.SeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.SeverityLevel =
      software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.INFORMATIVE
  }
  case object Low extends zio.aws.applicationinsights.model.SeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.SeverityLevel =
      software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.LOW
  }
  case object Medium extends zio.aws.applicationinsights.model.SeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.SeverityLevel =
      software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.MEDIUM
  }
  case object High extends zio.aws.applicationinsights.model.SeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.SeverityLevel =
      software.amazon.awssdk.services.applicationinsights.model.SeverityLevel.HIGH
  }
}
