package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait OsType {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.OsType
}
object OsType {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.OsType
  ): zio.aws.applicationinsights.model.OsType = value match {
    case software.amazon.awssdk.services.applicationinsights.model.OsType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.OsType.WINDOWS =>
      val r = WINDOWS
      r
    case software.amazon.awssdk.services.applicationinsights.model.OsType.LINUX =>
      val r = LINUX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.OsType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.OsType =
      software.amazon.awssdk.services.applicationinsights.model.OsType.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS extends zio.aws.applicationinsights.model.OsType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.OsType =
      software.amazon.awssdk.services.applicationinsights.model.OsType.WINDOWS
  }
  case object LINUX extends zio.aws.applicationinsights.model.OsType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.OsType =
      software.amazon.awssdk.services.applicationinsights.model.OsType.LINUX
  }
}
