package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApplicationResponse(
    applicationInfo: Optional[
      zio.aws.applicationinsights.model.ApplicationInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationResponse
      .builder()
      .optionallyWith(applicationInfo.map(value => value.buildAwsValue()))(
        _.applicationInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.applicationinsights.model.UpdateApplicationResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.UpdateApplicationResponse =
      zio.aws.applicationinsights.model.UpdateApplicationResponse(
        applicationInfo.map(value => value.asEditable)
      )
    def applicationInfo
        : Optional[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly]
    def getApplicationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("applicationInfo", applicationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationResponse
  ) extends zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly {
    override val applicationInfo
        : Optional[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationInfo())
        .map(value =>
          zio.aws.applicationinsights.model.ApplicationInfo.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationResponse
  ): zio.aws.applicationinsights.model.UpdateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
