package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait RecommendationType {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.RecommendationType
}
object RecommendationType {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.RecommendationType
  ): zio.aws.applicationinsights.model.RecommendationType = value match {
    case software.amazon.awssdk.services.applicationinsights.model.RecommendationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.RecommendationType.INFRA_ONLY =>
      val r = INFRA_ONLY
      r
    case software.amazon.awssdk.services.applicationinsights.model.RecommendationType.WORKLOAD_ONLY =>
      val r = WORKLOAD_ONLY
      r
    case software.amazon.awssdk.services.applicationinsights.model.RecommendationType.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.RecommendationType =
      software.amazon.awssdk.services.applicationinsights.model.RecommendationType.UNKNOWN_TO_SDK_VERSION
  }
  case object INFRA_ONLY
      extends zio.aws.applicationinsights.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.RecommendationType =
      software.amazon.awssdk.services.applicationinsights.model.RecommendationType.INFRA_ONLY
  }
  case object WORKLOAD_ONLY
      extends zio.aws.applicationinsights.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.RecommendationType =
      software.amazon.awssdk.services.applicationinsights.model.RecommendationType.WORKLOAD_ONLY
  }
  case object ALL extends zio.aws.applicationinsights.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.RecommendationType =
      software.amazon.awssdk.services.applicationinsights.model.RecommendationType.ALL
  }
}
