package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait LogFilter {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.LogFilter
}
object LogFilter {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.LogFilter
  ): zio.aws.applicationinsights.model.LogFilter = value match {
    case software.amazon.awssdk.services.applicationinsights.model.LogFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.LogFilter.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.applicationinsights.model.LogFilter.WARN =>
      val r = WARN
      r
    case software.amazon.awssdk.services.applicationinsights.model.LogFilter.INFO =>
      val r = INFO
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.LogFilter {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.LogFilter =
      software.amazon.awssdk.services.applicationinsights.model.LogFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object ERROR extends zio.aws.applicationinsights.model.LogFilter {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.LogFilter =
      software.amazon.awssdk.services.applicationinsights.model.LogFilter.ERROR
  }
  case object WARN extends zio.aws.applicationinsights.model.LogFilter {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.LogFilter =
      software.amazon.awssdk.services.applicationinsights.model.LogFilter.WARN
  }
  case object INFO extends zio.aws.applicationinsights.model.LogFilter {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.LogFilter =
      software.amazon.awssdk.services.applicationinsights.model.LogFilter.INFO
  }
}
