package zio.aws.applicationinsights.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  AccountId,
  PaginationToken,
  MaxEntities,
  ResourceGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListComponentsRequest(
    resourceGroupName: ResourceGroupName,
    maxResults: Optional[MaxEntities] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest = {
    import ListComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxEntities.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListComponentsRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListComponentsRequest
      .wrap(buildAwsValue())
}
object ListComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListComponentsRequest =
      zio.aws.applicationinsights.model.ListComponentsRequest(
        resourceGroupName,
        maxResults.map(value => value),
        nextToken.map(value => value),
        accountId.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def maxResults: Optional[MaxEntities]
    def nextToken: Optional[PaginationToken]
    def accountId: Optional[AccountId]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getMaxResults: ZIO[Any, AwsError, MaxEntities] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest
  ) extends zio.aws.applicationinsights.model.ListComponentsRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val maxResults: Optional[MaxEntities] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MaxEntities(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest
  ): zio.aws.applicationinsights.model.ListComponentsRequest.ReadOnly =
    new Wrapper(impl)
}
