package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  AccountId,
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComponentConfigurationRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest = {
    import DescribeComponentConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeComponentConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest =
      zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest(
        resourceGroupName,
        componentName,
        accountId.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def accountId: Optional[AccountId]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
  ) extends zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest
  ): zio.aws.applicationinsights.model.DescribeComponentConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
