package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddWorkloadRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    workloadConfiguration: zio.aws.applicationinsights.model.WorkloadConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.AddWorkloadRequest = {
    import AddWorkloadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.AddWorkloadRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .workloadConfiguration(workloadConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.AddWorkloadRequest.ReadOnly =
    zio.aws.applicationinsights.model.AddWorkloadRequest.wrap(buildAwsValue())
}
object AddWorkloadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.AddWorkloadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.AddWorkloadRequest =
      zio.aws.applicationinsights.model.AddWorkloadRequest(
        resourceGroupName,
        componentName,
        workloadConfiguration.asEditable
      )
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def workloadConfiguration
        : zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getWorkloadConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ] = ZIO.succeed(workloadConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.AddWorkloadRequest
  ) extends zio.aws.applicationinsights.model.AddWorkloadRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val workloadConfiguration
        : zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly =
      zio.aws.applicationinsights.model.WorkloadConfiguration
        .wrap(impl.workloadConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.AddWorkloadRequest
  ): zio.aws.applicationinsights.model.AddWorkloadRequest.ReadOnly =
    new Wrapper(impl)
}
