package zio.aws.applicationinsights.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  MaxEntities,
  AccountId,
  EndTime,
  StartTime,
  PaginationToken,
  ResourceGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListConfigurationHistoryRequest(
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    startTime: Optional[StartTime] = Optional.Absent,
    endTime: Optional[EndTime] = Optional.Absent,
    eventStatus: Optional[
      zio.aws.applicationinsights.model.ConfigurationEventStatus
    ] = Optional.Absent,
    maxResults: Optional[MaxEntities] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest = {
    import ListConfigurationHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(eventStatus.map(value => value.unwrap))(_.eventStatus)
      .optionallyWith(
        maxResults.map(value => MaxEntities.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListConfigurationHistoryRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListConfigurationHistoryRequest
      .wrap(buildAwsValue())
}
object ListConfigurationHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.ListConfigurationHistoryRequest =
      zio.aws.applicationinsights.model.ListConfigurationHistoryRequest(
        resourceGroupName.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        eventStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        accountId.map(value => value)
      )
    def resourceGroupName: Optional[ResourceGroupName]
    def startTime: Optional[StartTime]
    def endTime: Optional[EndTime]
    def eventStatus
        : Optional[zio.aws.applicationinsights.model.ConfigurationEventStatus]
    def maxResults: Optional[MaxEntities]
    def nextToken: Optional[PaginationToken]
    def accountId: Optional[AccountId]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEventStatus: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ConfigurationEventStatus
    ] = AwsError.unwrapOptionField("eventStatus", eventStatus)
    def getMaxResults: ZIO[Any, AwsError, MaxEntities] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
  ) extends zio.aws.applicationinsights.model.ListConfigurationHistoryRequest.ReadOnly {
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StartTime(value)
      )
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.applicationinsights.model.primitives.EndTime(value))
    override val eventStatus
        : Optional[zio.aws.applicationinsights.model.ConfigurationEventStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventStatus())
        .map(value =>
          zio.aws.applicationinsights.model.ConfigurationEventStatus.wrap(value)
        )
    override val maxResults: Optional[MaxEntities] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MaxEntities(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest
  ): zio.aws.applicationinsights.model.ListConfigurationHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
