package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  AccountId,
  LogPatternName,
  LogPatternSetName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLogPatternRequest(
    resourceGroupName: ResourceGroupName,
    patternSetName: LogPatternSetName,
    patternName: LogPatternName,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest = {
    import DescribeLogPatternRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .patternSetName(
        LogPatternSetName.unwrap(patternSetName): java.lang.String
      )
      .patternName(LogPatternName.unwrap(patternName): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeLogPatternRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeLogPatternRequest
      .wrap(buildAwsValue())
}
object DescribeLogPatternRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeLogPatternRequest =
      zio.aws.applicationinsights.model.DescribeLogPatternRequest(
        resourceGroupName,
        patternSetName,
        patternName,
        accountId.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def patternSetName: LogPatternSetName
    def patternName: LogPatternName
    def accountId: Optional[AccountId]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getPatternSetName: ZIO[Any, Nothing, LogPatternSetName] =
      ZIO.succeed(patternSetName)
    def getPatternName: ZIO[Any, Nothing, LogPatternName] =
      ZIO.succeed(patternName)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest
  ) extends zio.aws.applicationinsights.model.DescribeLogPatternRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val patternSetName: LogPatternSetName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternSetName(impl.patternSetName())
    override val patternName: LogPatternName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternName(impl.patternName())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest
  ): zio.aws.applicationinsights.model.DescribeLogPatternRequest.ReadOnly =
    new Wrapper(impl)
}
