package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListConfigurationHistoryResponse(
    eventList: Optional[
      Iterable[zio.aws.applicationinsights.model.ConfigurationEvent]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse = {
    import ListConfigurationHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse
      .builder()
      .optionallyWith(
        eventList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListConfigurationHistoryResponse
      .wrap(buildAwsValue())
}
object ListConfigurationHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.ListConfigurationHistoryResponse =
      zio.aws.applicationinsights.model.ListConfigurationHistoryResponse(
        eventList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventList: Optional[
      List[zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getEventList: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("eventList", eventList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse
  ) extends zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly {
    override val eventList: Optional[
      List[zio.aws.applicationinsights.model.ConfigurationEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationinsights.model.ConfigurationEvent.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse
  ): zio.aws.applicationinsights.model.ListConfigurationHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
