package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ComponentConfiguration
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComponentConfigurationRecommendationResponse(
    componentConfiguration: Optional[ComponentConfiguration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse = {
    import DescribeComponentConfigurationRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
      .builder()
      .optionallyWith(
        componentConfiguration.map(value =>
          ComponentConfiguration.unwrap(value): java.lang.String
        )
      )(_.componentConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
      .wrap(buildAwsValue())
}
object DescribeComponentConfigurationRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse =
      zio.aws.applicationinsights.model
        .DescribeComponentConfigurationRecommendationResponse(
          componentConfiguration.map(value => value)
        )
    def componentConfiguration: Optional[ComponentConfiguration]
    def getComponentConfiguration: ZIO[Any, AwsError, ComponentConfiguration] =
      AwsError.unwrapOptionField(
        "componentConfiguration",
        componentConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
  ) extends zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly {
    override val componentConfiguration: Optional[ComponentConfiguration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentConfiguration())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ComponentConfiguration(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
  ): zio.aws.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
